/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.server;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.config.RepositoryConfiguration;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.screens.examples.service.ImportService;
import org.kie.workbench.common.screens.examples.validation.ImportProjectValidator;
import org.kie.workbench.common.screens.examples.validation.ImportProjectValidators;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.kie.workbench.common.screens.projecteditor.service.ProjectScreenService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

public abstract class BaseProjectImportService
implements ImportService {
    private static final String PROJECT_DESCRIPTON = "project.description";
    private static final String SYSTEM = "system";
    protected IOService ioService;
    protected MetadataService metadataService;
    protected ImportProjectValidators validators;
    protected KieModuleService moduleService;
    protected WorkspaceProjectService projectService;
    protected ProjectScreenService projectScreenService;
    protected SpaceConfigStorageRegistry spaceConfigStorageRegistry;

    public BaseProjectImportService(IOService ioService, MetadataService metadataService, ImportProjectValidators validators, KieModuleService moduleService, WorkspaceProjectService projectService, ProjectScreenService projectScreenService, SpaceConfigStorageRegistry spaceConfigStorageRegistry) {
        this.ioService = ioService;
        this.metadataService = metadataService;
        this.validators = validators;
        this.moduleService = moduleService;
        this.projectService = projectService;
        this.projectScreenService = projectScreenService;
        this.spaceConfigStorageRegistry = spaceConfigStorageRegistry;
    }

    protected String getRepositoryAlias(String url) {
        String alias = url;
        int lastDotIndex = (alias = alias.substring(alias.lastIndexOf(47) + 1)).lastIndexOf(46);
        if (lastDotIndex > 0) {
            alias = alias.substring(0, lastDotIndex);
        }
        return alias;
    }

    protected List<String> getTags(Module module) {
        List tags = this.metadataService.getTags(module.getPomXMLPath());
        tags.sort(String::compareTo);
        return tags;
    }

    protected Set<ImportProject> convert(Branch branch, ExampleRepository repository) {
        Set modules = this.moduleService.getAllModules(branch);
        return modules.stream().map(p -> this.makeExampleProject((Module)p, repository)).collect(Collectors.toSet());
    }

    protected ImportProject makeExampleProject(Module module, ExampleRepository repository) {
        String description = this.readDescription(module);
        List<String> tags = this.getTags(module);
        return new ImportProject(module.getRootPath(), module.getModuleName(), description, repository.getUrl(), tags, repository.getCredentials(), Collections.emptyList(), false);
    }

    protected String readDescription(Module module) {
        org.uberfire.backend.vfs.Path root = module.getRootPath();
        POM pom = module.getPom();
        Path nioRoot = Paths.convert((org.uberfire.backend.vfs.Path)root);
        Path nioDescription = nioRoot.resolve(PROJECT_DESCRIPTON);
        String description = "Example '" + module.getModuleName() + "' module";
        if (this.ioService.exists(nioDescription)) {
            description = this.ioService.readAllString(nioDescription);
        } else if (pom != null && pom.getDescription() != null && !pom.getDescription().isEmpty()) {
            description = pom.getDescription();
        }
        if (description != null) {
            return description.replaceAll("\\s+", " ");
        }
        return description;
    }

    protected Set<ImportProject> validateProjects(Set<ImportProject> projects) {
        return projects.stream().map(project -> {
            List errors = this.getValidators().stream().map(exampleProjectValidation -> exampleProjectValidation.validate(project)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            return new ImportProject(project.getRoot(), project.getName(), project.getDescription(), project.getOrigin(), project.getTags(), errors, project.getCredentials(), project.getAllBranches(), project.getSelectedBranches(), project.canSelectBranches());
        }).collect(Collectors.toSet());
    }

    protected RepositoryInfo createConfigGroup(String alias, Map<String, Object> env) {
        RepositoryConfiguration configuration = new RepositoryConfiguration(env);
        configuration.add("avoid_index", (Object)true);
        configuration.add("space", (Object)SYSTEM);
        RepositoryInfo repositoryConfig = new RepositoryInfo(alias, false, configuration);
        return repositoryConfig;
    }

    protected Map<String, Object> buildGitEnv(final String url, final String username, final String password, final boolean mirror) {
        return new HashMap<String, Object>(){
            {
                this.put("origin", url);
                this.put("scheme", GitRepository.SCHEME.toString());
                this.put("replaceIfExists", true);
                this.put("username", username);
                this.put("password", password);
                this.put("mirror", mirror);
            }
        };
    }

    protected WorkspaceProject renameIfNecessary(OrganizationalUnit ou, WorkspaceProject project) {
        String name = project.getName();
        Collection projectsWithSameName = this.projectService.getAllWorkspaceProjectsByName(ou, name);
        if (projectsWithSameName.size() > 1) {
            name = this.projectService.createFreshProjectName(ou, project.getName());
        }
        if (!name.equals(project.getName())) {
            org.uberfire.backend.vfs.Path pomXMLPath = project.getMainModule().getPomXMLPath();
            ProjectScreenModel model = this.projectScreenService.load(pomXMLPath);
            model.getPOM().setName(name);
            this.projectScreenService.save(pomXMLPath, model, "");
            return this.projectService.resolveProject(pomXMLPath);
        }
        return project;
    }

    public Set<ImportProject> getProjects(ExampleRepository repository) {
        if (repository == null) {
            return Collections.emptySet();
        }
        String repositoryURL = repository.getUrl();
        if (repositoryURL == null || repositoryURL.trim().isEmpty()) {
            return Collections.emptySet();
        }
        Repository gitRepository = this.resolveGitRepository(repository);
        if (gitRepository == null) {
            return Collections.emptySet();
        }
        Set<ImportProject> importProjects = this.convert((Branch)gitRepository.getBranch("master").get(), repository);
        return this.validateProjects(importProjects);
    }

    protected List<ImportProjectValidator> getValidators() {
        return this.validators.getValidators();
    }

    protected abstract Repository resolveGitRepository(ExampleRepository var1);
}

