/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.uni;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.drools.core.base.accumulators.CollectSetAccumulateFunction;
import org.drools.model.BetaIndex;
import org.drools.model.DSL;
import org.drools.model.Declaration;
import org.drools.model.DeclarationSource;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block3;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.Predicate2;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiCondition;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsCondition;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsPatternBuilder;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsGroupByAccumulator;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsGroupByInvoker;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniAccumulateFunctionBridge;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniRuleStructure;

public final class DroolsUniCondition<A>
extends DroolsCondition<DroolsUniRuleStructure<A>> {
    public DroolsUniCondition(Class<A> aVariableType, LongSupplier variableIdSupplier) {
        this(new DroolsUniRuleStructure<A>(aVariableType, variableIdSupplier));
    }

    public DroolsUniCondition(DroolsUniRuleStructure<A> ruleStructure) {
        super(ruleStructure);
    }

    public static Index.ConstraintType getConstraintType(JoinerType type) {
        switch (type) {
            case EQUAL: {
                return Index.ConstraintType.EQUAL;
            }
            case LESS_THAN: {
                return Index.ConstraintType.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return Index.ConstraintType.LESS_OR_EQUAL;
            }
            case GREATER_THAN: {
                return Index.ConstraintType.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return Index.ConstraintType.GREATER_OR_EQUAL;
            }
        }
        throw new IllegalStateException("Unsupported joiner type (" + (Object)((Object)type) + ").");
    }

    public DroolsUniCondition<A> andFilter(Predicate<A> predicate) {
        Predicate1 & Serializable filter = (Predicate1 & Serializable)a -> predicate.test(a);
        DroolsPatternBuilder<Object> patternWithFilter = ((DroolsUniRuleStructure)this.ruleStructure).getPrimaryPattern().expand(p -> p.expr("Filter using " + predicate, filter, PatternDSL.alphaIndexedBy(Boolean.class, (Index.ConstraintType)Index.ConstraintType.EQUAL, (int)-1, (Function1 & Serializable)a -> predicate.test(a), (Object)true)));
        DroolsUniRuleStructure newStructure = new DroolsUniRuleStructure(((DroolsUniRuleStructure)this.ruleStructure).getA(), patternWithFilter, ((DroolsUniRuleStructure)this.ruleStructure).getSupportingRuleItems(), ((DroolsUniRuleStructure)this.ruleStructure).getVariableIdSupplier());
        return new DroolsUniCondition(newStructure);
    }

    public <NewA, ResultContainer> DroolsUniCondition<NewA> andCollect(UniConstraintCollector<A, ResultContainer, NewA> collector) {
        Variable inputVariable = ((DroolsUniRuleStructure)this.ruleStructure).getA();
        PatternDSL.PatternDef<Object> innerAccumulatePattern = ((DroolsUniRuleStructure)this.ruleStructure).getPrimaryPattern().build();
        DroolsUniAccumulateFunctionBridge accumulateFunction = new DroolsUniAccumulateFunctionBridge(collector);
        Declaration outputVariable = DSL.declarationOf(Object.class);
        DroolsPatternBuilder accumulateResult = new DroolsPatternBuilder(outputVariable);
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)DSL.accFunction(() -> accumulateFunction, inputVariable).as((Variable)outputVariable), (AccumulateFunction[])new AccumulateFunction[0]);
        DroolsUniRuleStructure newRuleStructure = new DroolsUniRuleStructure(outputVariable, accumulateResult, ((DroolsUniRuleStructure)this.ruleStructure).rebuildSupportingRuleItems(new RuleItemBuilder[]{outerAccumulatePattern}), ((DroolsUniRuleStructure)this.ruleStructure).getVariableIdSupplier());
        return new DroolsUniCondition(newRuleStructure);
    }

    public <NewA> DroolsUniCondition<NewA> andGroup(Function<A, NewA> groupKeyMapping) {
        Variable mappedVariable = ((DroolsUniRuleStructure)this.ruleStructure).createVariable("mapped");
        PatternDSL.PatternDef<Object> innerAccumulatePattern = ((DroolsUniRuleStructure)this.ruleStructure).getPrimaryPattern().expand(p -> p.bind(mappedVariable, (Function1 & Serializable)k -> groupKeyMapping.apply(k))).build();
        Variable<Set> setOfGroupKeys = ((DroolsUniRuleStructure)this.ruleStructure).createVariable(Set.class, "setOfGroupKey");
        PatternDSL.PatternDef pattern = PatternDSL.pattern(setOfGroupKeys).expr("Set of groupKey", (Predicate1 & Serializable)set -> !set.isEmpty(), PatternDSL.alphaIndexedBy(Integer.class, (Index.ConstraintType)Index.ConstraintType.GREATER_THAN, (int)-1, Set::size, (Object)0));
        ExprViewItem accumulate = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)DSL.accFunction(CollectSetAccumulateFunction.class, mappedVariable).as(setOfGroupKeys), (AccumulateFunction[])new AccumulateFunction[0]);
        Variable groupKey = ((DroolsUniRuleStructure)this.ruleStructure).createVariable("groupKey", (DeclarationSource)PatternDSL.from(setOfGroupKeys));
        DroolsPatternBuilder finalGroupKeyPattern = new DroolsPatternBuilder(groupKey);
        DroolsUniRuleStructure newRuleStructure = new DroolsUniRuleStructure(groupKey, finalGroupKeyPattern, ((DroolsUniRuleStructure)this.ruleStructure).rebuildSupportingRuleItems(new RuleItemBuilder[]{pattern, accumulate}), ((DroolsUniRuleStructure)this.ruleStructure).getVariableIdSupplier());
        return new DroolsUniCondition(newRuleStructure);
    }

    public <ResultContainer, NewA, NewB> DroolsBiCondition<NewA, NewB> andGroupWithCollect(Function<A, NewA> groupKeyMapping, UniConstraintCollector<A, ResultContainer, NewB> collector) {
        Variable collectingOnVar = ((DroolsUniRuleStructure)this.ruleStructure).createVariable(((DroolsUniRuleStructure)this.ruleStructure).getA().getType(), "collectingOn");
        Variable groupKeyVar = ((DroolsUniRuleStructure)this.ruleStructure).createVariable("groupKey");
        Variable<Set> setOfPairsVar = ((DroolsUniRuleStructure)this.ruleStructure).createVariable(Set.class, "setOfPairs");
        PatternDSL.PatternDef pattern = PatternDSL.pattern(setOfPairsVar).expr("Set of groupBy+collect pairs", (Predicate1 & Serializable)set -> !set.isEmpty(), PatternDSL.alphaIndexedBy(Integer.class, (Index.ConstraintType)Index.ConstraintType.GREATER_THAN, (int)-1, Set::size, (Object)0));
        PatternDSL.PatternDef<Object> innerNewACollectingPattern = ((DroolsUniRuleStructure)this.ruleStructure).getPrimaryPattern().expand(p -> p.bind(groupKeyVar, (Function1 & Serializable)a -> groupKeyMapping.apply(a)).bind(collectingOnVar, (Function1 & Serializable)a -> a)).build();
        ExprViewItem accumulate = DSL.accumulate(innerNewACollectingPattern, (AccumulateFunction)DSL.accFunction(() -> new DroolsGroupByInvoker(collector, groupKeyVar, collectingOnVar)).as(setOfPairsVar), (AccumulateFunction[])new AccumulateFunction[0]);
        Variable<DroolsGroupByAccumulator.Pair> onePairVar = ((DroolsUniRuleStructure)this.ruleStructure).createVariable(DroolsGroupByAccumulator.Pair.class, "pair", (DeclarationSource)PatternDSL.from(setOfPairsVar));
        Variable newAVar = ((DroolsUniRuleStructure)this.ruleStructure).createVariable("newA");
        Variable newBVar = ((DroolsUniRuleStructure)this.ruleStructure).createVariable("newB");
        DroolsPatternBuilder<DroolsGroupByAccumulator.Pair> finalPairPattern = new DroolsPatternBuilder<DroolsGroupByAccumulator.Pair>(onePairVar).expand(p -> p.bind(newAVar, (Function1 & Serializable)pair -> pair.key)).expand(p -> p.bind(newBVar, (Function1 & Serializable)pair -> pair.value));
        DroolsBiRuleStructure newRuleStructure = new DroolsBiRuleStructure(newAVar, newBVar, finalPairPattern, ((DroolsUniRuleStructure)this.ruleStructure).rebuildSupportingRuleItems(new RuleItemBuilder[]{pattern, accumulate}), ((DroolsUniRuleStructure)this.ruleStructure).getVariableIdSupplier());
        return new DroolsBiCondition(newRuleStructure);
    }

    public <B> DroolsBiCondition<A, B> andJoin(DroolsUniCondition<B> bCondition, AbstractBiJoiner<A, B> biJoiner) {
        JoinerType[] joinerTypes = biJoiner.getJoinerTypes();
        DroolsPatternBuilder<Object> newAPattern = ((DroolsUniRuleStructure)this.ruleStructure).getPrimaryPattern();
        Variable[] joinVars = new Variable[joinerTypes.length];
        int mappingIndex = 0;
        while (mappingIndex < joinerTypes.length) {
            int currentMappingIndex = mappingIndex++;
            Variable joinVar = ((DroolsUniRuleStructure)this.ruleStructure).createVariable("joinVar" + currentMappingIndex);
            Function leftMapping = biJoiner.getLeftMapping(currentMappingIndex);
            newAPattern = newAPattern.expand(p -> p.bind(joinVar, (Function1 & Serializable)a -> leftMapping.apply(a)));
            joinVars[currentMappingIndex] = joinVar;
        }
        DroolsUniRuleStructure newARuleStructure = new DroolsUniRuleStructure(((DroolsUniRuleStructure)this.ruleStructure).getA(), newAPattern, ((DroolsUniRuleStructure)this.ruleStructure).getSupportingRuleItems(), ((DroolsUniRuleStructure)this.ruleStructure).getVariableIdSupplier());
        DroolsUniRuleStructure bRuleStructure = (DroolsUniRuleStructure)bCondition.ruleStructure;
        Variable bVariable = bRuleStructure.getA();
        DroolsPatternBuilder<Object> newBPattern = bRuleStructure.getPrimaryPattern();
        int mappingIndex2 = 0;
        while (mappingIndex2 < joinerTypes.length) {
            int currentMappingIndex = mappingIndex2++;
            JoinerType joinerType = joinerTypes[currentMappingIndex];
            Function leftMapping = biJoiner.getLeftMapping(currentMappingIndex);
            Function rightMapping = biJoiner.getRightMapping(currentMappingIndex);
            Function1 & Serializable rightExtractor = (Function1 & Serializable)b -> rightMapping.apply(b);
            Predicate2 & Serializable predicate = (Predicate2 & Serializable)(b, a) -> joinerType.matches(a, rightExtractor.apply(b));
            newBPattern = newBPattern.expand(p -> {
                BetaIndex betaIndex = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)DroolsUniCondition.getConstraintType(joinerType), (int)currentMappingIndex, (Function1)rightExtractor, leftMapping::apply);
                return p.expr("Join using joiner #" + currentMappingIndex + " in " + biJoiner, joinVars[currentMappingIndex], predicate, betaIndex);
            });
        }
        DroolsUniRuleStructure newBRuleStructure = new DroolsUniRuleStructure(bVariable, newBPattern, bRuleStructure.getSupportingRuleItems(), ((DroolsUniRuleStructure)this.ruleStructure).getVariableIdSupplier());
        return new DroolsBiCondition(new DroolsBiRuleStructure(newARuleStructure, newBRuleStructure, ((DroolsUniRuleStructure)this.ruleStructure).getVariableIdSupplier()));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        return this.completeWithScoring(scoreHolderGlobal, (Block3 & Serializable)(drools, scoreHolder, __) -> this.impactScore((Drools)drools, scoreHolder));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToIntFunction<A> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block3 & Serializable)(drools, scoreHolder, a) -> this.impactScore((Drools)drools, scoreHolder, matchWeighter.applyAsInt(a)));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToLongFunction<A> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block3 & Serializable)(drools, scoreHolder, a) -> this.impactScore((Drools)drools, scoreHolder, matchWeighter.applyAsLong(a)));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, Function<A, BigDecimal> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block3 & Serializable)(drools, scoreHolder, a) -> this.impactScore((Drools)drools, scoreHolder, (BigDecimal)matchWeighter.apply(a)));
    }

    private <ScoreHolder extends AbstractScoreHolder<?>> List<RuleItemBuilder<?>> completeWithScoring(Global<ScoreHolder> scoreHolderGlobal, Block3<Drools, ScoreHolder, A> consequenceImpl) {
        ConsequenceBuilder._2 consequence = DSL.on(scoreHolderGlobal, ((DroolsUniRuleStructure)this.ruleStructure).getA()).execute(consequenceImpl);
        return ((DroolsUniRuleStructure)this.ruleStructure).rebuildSupportingRuleItems(new RuleItemBuilder[]{((DroolsUniRuleStructure)this.ruleStructure).getPrimaryPattern().build(), consequence});
    }
}

