/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend.dataproviders;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.stunner.bpmn.project.backend.service.ProcessesDataService;
import org.kie.workbench.common.stunner.cm.backend.query.FindCaseManagementIdsQuery;

@Dependent
public class CaseCalledElementFormDataProvider {
    private final ProcessesDataService dataService;

    @Inject
    public CaseCalledElementFormDataProvider(ProcessesDataService dataService) {
        this.dataService = dataService;
    }

    @PostConstruct
    public void init() {
        this.dataService.setQueryName(() -> FindCaseManagementIdsQuery.NAME);
        this.dataService.setResourceType(() -> ResourceType.BPMN_CM);
    }

    public Map<Object, String> getBusinessProcessIDs() {
        return CaseCalledElementFormDataProvider.toMap(this.dataService.getBusinessProcessIDs());
    }

    private static Map<Object, String> toMap(Iterable<String> items) {
        return StreamSupport.stream(items.spliterator(), false).collect(Collectors.toMap(s -> s, s -> s));
    }
}

