/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.types;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.workbench.common.dmn.api.editors.types.DataObject;
import org.kie.workbench.common.dmn.api.editors.types.DataObjectProperty;
import org.kie.workbench.common.dmn.api.editors.types.DataObjectsService;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodel.util.PrimitiveUtilities;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;

@Service
@Dependent
public class DataObjectsServiceImpl
implements DataObjectsService {
    private DataModelService dataModelService;
    private ModuleClassLoaderHelper moduleClassLoaderHelper;
    private KieModuleService moduleService;

    protected DataObjectsServiceImpl() {
        this(null, null, null);
    }

    @Inject
    public DataObjectsServiceImpl(DataModelService dataModelService, ModuleClassLoaderHelper moduleClassLoaderHelper, KieModuleService moduleService) {
        this.dataModelService = dataModelService;
        this.moduleClassLoaderHelper = moduleClassLoaderHelper;
        this.moduleService = moduleService;
    }

    public List<DataObject> loadDataObjects(WorkspaceProject workspaceProject) {
        KieModule module = (KieModule)this.moduleService.resolveModule(workspaceProject.getRootPath());
        ClassLoader classLoader = this.moduleClassLoaderHelper.getModuleClassLoader(module);
        ModuleDataModelOracle dmo = this.dataModelService.getModuleDataModel(workspaceProject.getRootPath());
        String[] types = DataModelOracleUtilities.getFactTypes((ModuleDataModelOracle)dmo);
        Map typesModelFields = dmo.getModuleModelFields();
        List<DataObject> dataObjects = Arrays.stream(types).map(DataObject::new).collect(Collectors.toList());
        dataObjects.forEach(dataObject -> this.convertProperties((DataObject)dataObject, dataObjects, typesModelFields, classLoader));
        return dataObjects;
    }

    private void convertProperties(DataObject dataObject, List<DataObject> dataObjects, Map<String, ModelField[]> typesModelFields, ClassLoader classLoader) {
        ModelField[] typeModelFields = typesModelFields.getOrDefault(dataObject.getClassType(), new ModelField[0]);
        dataObject.setProperties(Arrays.stream(typeModelFields).filter(typeModelField -> !Objects.equals(typeModelField.getName(), "this")).map(typeModelField -> this.convertProperty((ModelField)typeModelField, dataObjects, classLoader)).collect(Collectors.toList()));
    }

    private DataObjectProperty convertProperty(ModelField field, List<DataObject> dataObjects, ClassLoader classLoader) {
        DataObjectProperty dataObjectProperty = new DataObjectProperty();
        dataObjectProperty.setType(this.convertDataType(field.getClassName(), dataObjects, classLoader));
        dataObjectProperty.setProperty(field.getName());
        return dataObjectProperty;
    }

    private String convertDataType(String typeName, List<DataObject> dataObjects, ClassLoader classLoader) {
        for (DataObject dataObject : dataObjects) {
            if (!Objects.equals(typeName, dataObject.getClassType())) continue;
            return typeName;
        }
        try {
            String className = PrimitiveUtilities.getClassNameForPrimitiveType((String)typeName);
            Class<?> clazz = classLoader.loadClass(Objects.nonNull(className) ? className : typeName);
            BuiltInType builtInType = this.determineBuiltInTypeFromClass(clazz);
            if (Objects.nonNull(builtInType)) {
                return builtInType.getName();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return BuiltInType.ANY.getName();
    }

    private BuiltInType determineBuiltInTypeFromClass(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            return BuiltInType.UNDEFINED;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return BuiltInType.NUMBER;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return BuiltInType.STRING;
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return BuiltInType.STRING;
        }
        if (LocalDate.class.isAssignableFrom(clazz)) {
            return BuiltInType.DATE;
        }
        if (LocalTime.class.isAssignableFrom(clazz) || OffsetTime.class.isAssignableFrom(clazz)) {
            return BuiltInType.TIME;
        }
        if (ZonedDateTime.class.isAssignableFrom(clazz) || OffsetDateTime.class.isAssignableFrom(clazz) || LocalDateTime.class.isAssignableFrom(clazz)) {
            return BuiltInType.DATE_TIME;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return BuiltInType.BOOLEAN;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return BuiltInType.CONTEXT;
        }
        return BuiltInType.ANY;
    }
}

