/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.lang.ref.PhantomReference;
import org.postgresql.core.Field;
import org.postgresql.core.NativeQuery;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Utils;
import org.postgresql.core.v3.ProtocolConnectionImpl;
import org.postgresql.core.v3.SimpleParameterList;
import org.postgresql.core.v3.V3Query;

class SimpleQuery
implements V3Query {
    private final NativeQuery nativeQuery;
    private final ProtocolConnectionImpl protoConnection;
    private String statementName;
    private byte[] encodedStatementName;
    private Field[] fields;
    private boolean needUpdateFieldFormats;
    private boolean hasBinaryFields;
    private boolean portalDescribed;
    private boolean statementDescribed;
    private PhantomReference cleanupRef;
    private int[] preparedTypes;
    private Integer cachedMaxResultRowSize;
    static final SimpleParameterList NO_PARAMETERS = new SimpleParameterList(0, null);

    SimpleQuery(NativeQuery query, ProtocolConnectionImpl protoConnection) {
        this.nativeQuery = query;
        this.protoConnection = protoConnection;
    }

    public ParameterList createParameterList() {
        if (this.nativeQuery.bindPositions.length == 0) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.nativeQuery.bindPositions.length, this.protoConnection);
    }

    public String toString(ParameterList parameters) {
        return this.nativeQuery.toString(parameters);
    }

    public String toString() {
        return this.toString(null);
    }

    public void close() {
        this.unprepare();
    }

    public SimpleQuery[] getSubqueries() {
        return null;
    }

    public int getMaxResultRowSize() {
        if (this.cachedMaxResultRowSize != null) {
            return this.cachedMaxResultRowSize;
        }
        if (!this.statementDescribed) {
            throw new IllegalStateException("Cannot estimate result row size on a statement that is not described");
        }
        int maxResultRowSize = 0;
        if (this.fields != null) {
            for (Field f : this.fields) {
                int fieldLength = f.getLength();
                if (fieldLength < 1 || fieldLength >= 65535) {
                    maxResultRowSize = -1;
                    break;
                }
                maxResultRowSize += fieldLength;
            }
        }
        this.cachedMaxResultRowSize = maxResultRowSize;
        return maxResultRowSize;
    }

    String getNativeSql() {
        return this.nativeQuery.nativeSql;
    }

    void setStatementName(String statementName) {
        this.statementName = statementName;
        this.encodedStatementName = Utils.encodeUTF8(statementName);
    }

    void setStatementTypes(int[] paramTypes) {
        this.preparedTypes = paramTypes;
    }

    int[] getStatementTypes() {
        return this.preparedTypes;
    }

    String getStatementName() {
        return this.statementName;
    }

    boolean isPreparedFor(int[] paramTypes) {
        if (this.statementName == null) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i] == 0 || paramTypes[i] == this.preparedTypes[i]) continue;
            return false;
        }
        return true;
    }

    boolean hasUnresolvedTypes() {
        if (this.preparedTypes == null) {
            return true;
        }
        for (int preparedType : this.preparedTypes) {
            if (preparedType != 0) continue;
            return true;
        }
        return false;
    }

    byte[] getEncodedStatementName() {
        return this.encodedStatementName;
    }

    void setFields(Field[] fields) {
        this.fields = fields;
        this.cachedMaxResultRowSize = null;
        this.needUpdateFieldFormats = fields != null;
        this.hasBinaryFields = false;
    }

    Field[] getFields() {
        return this.fields;
    }

    boolean needUpdateFieldFormats() {
        if (this.needUpdateFieldFormats) {
            this.needUpdateFieldFormats = false;
            return true;
        }
        return false;
    }

    public boolean hasBinaryFields() {
        return this.hasBinaryFields;
    }

    public void setHasBinaryFields(boolean hasBinaryFields) {
        this.hasBinaryFields = hasBinaryFields;
    }

    boolean isPortalDescribed() {
        return this.portalDescribed;
    }

    void setPortalDescribed(boolean portalDescribed) {
        this.portalDescribed = portalDescribed;
        this.cachedMaxResultRowSize = null;
    }

    public boolean isStatementDescribed() {
        return this.statementDescribed;
    }

    void setStatementDescribed(boolean statementDescribed) {
        this.statementDescribed = statementDescribed;
        this.cachedMaxResultRowSize = null;
    }

    public boolean isEmpty() {
        return this.getNativeSql().isEmpty();
    }

    void setCleanupRef(PhantomReference cleanupRef) {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
        }
        this.cleanupRef = cleanupRef;
    }

    void unprepare() {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
            this.cleanupRef = null;
        }
        this.statementName = null;
        this.encodedStatementName = null;
        this.fields = null;
        this.portalDescribed = false;
        this.statementDescribed = false;
        this.cachedMaxResultRowSize = null;
    }
}

