/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.Property;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AssociationDeclaration;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.OutputAssignmentReader;
import org.mockito.Mockito;

public class OutputAssignmentReaderTest {
    private static final String SOURCE_NAME = "SOURCE_NAME";
    private static final String TARGET_NAME = "TARGET_NAME";
    private static final String TARGET_ID = "TARGET_ID";

    @Test
    public void testFromAssociationWithPropertyName() {
        Property property = OutputAssignmentReaderTest.mockProperty(TARGET_ID, TARGET_NAME);
        DataOutputAssociation outputAssociation = OutputAssignmentReaderTest.mockDataOutputAssociation(SOURCE_NAME, (ItemAwareElement)property);
        OutputAssignmentReader outputReader = OutputAssignmentReader.fromAssociation((DataOutputAssociation)outputAssociation);
        Assert.assertNotNull((Object)outputReader);
        this.assertResult(SOURCE_NAME, TARGET_NAME, outputReader.getAssociationDeclaration());
    }

    @Test
    public void testFromAssociationWithPropertyId() {
        Property property = OutputAssignmentReaderTest.mockProperty(TARGET_ID, null);
        DataOutputAssociation outputAssociation = OutputAssignmentReaderTest.mockDataOutputAssociation(SOURCE_NAME, (ItemAwareElement)property);
        OutputAssignmentReader outputReader = OutputAssignmentReader.fromAssociation((DataOutputAssociation)outputAssociation);
        Assert.assertNotNull((Object)outputReader);
        this.assertResult(SOURCE_NAME, TARGET_ID, outputReader.getAssociationDeclaration());
    }

    @Test
    public void testFromAssociationWithNonPropertyItem() {
        ItemAwareElement item = (ItemAwareElement)Mockito.mock(ItemAwareElement.class);
        DataOutputAssociation outputAssociation = OutputAssignmentReaderTest.mockDataOutputAssociation(SOURCE_NAME, item);
        Assert.assertNull((Object)OutputAssignmentReader.fromAssociation((DataOutputAssociation)outputAssociation));
    }

    private void assertResult(String sourceName, String targetId, AssociationDeclaration associationDeclaration) {
        Assert.assertNotNull((Object)associationDeclaration);
        Assert.assertEquals((Object)sourceName, (Object)associationDeclaration.getSource());
        Assert.assertEquals((Object)targetId, (Object)associationDeclaration.getTarget());
        Assert.assertEquals((Object)AssociationDeclaration.Type.SourceTarget, (Object)associationDeclaration.getType());
        Assert.assertEquals((Object)AssociationDeclaration.Direction.Output, (Object)associationDeclaration.getDirection());
    }

    private static Property mockProperty(String id, String name) {
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)property.getId()).thenReturn((Object)id);
        Mockito.when((Object)property.getName()).thenReturn((Object)name);
        return property;
    }

    private static DataOutputAssociation mockDataOutputAssociation(String dataOutputName, ItemAwareElement targetRef) {
        DataOutputAssociation outputAssociation = (DataOutputAssociation)Mockito.mock(DataOutputAssociation.class);
        DataOutput dataOutput = (DataOutput)Mockito.mock(DataOutput.class);
        Mockito.when((Object)dataOutput.getName()).thenReturn((Object)dataOutputName);
        List<DataOutput> sourceRefs = Collections.singletonList(dataOutput);
        Mockito.when((Object)outputAssociation.getSourceRef()).thenReturn(sourceRefs);
        Mockito.when((Object)outputAssociation.getTargetRef()).thenReturn((Object)targetRef);
        return outputAssociation;
    }
}

