/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.BoundaryCatchingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.CancellingEscalationEventExecutionSet;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class BoundaryCatchingIntermediateEscalationEventTest
extends BoundaryCatchingIntermediateEventTest<IntermediateEscalationEvent> {
    private static final String BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/boundaryEscalationEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_C4710D6A-661D-4E8A-9F1E-364F592FBDA4";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_688A335E-4CFB-4B02-94EC-E3019727AE4E";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_26F7F387-C073-406E-B75B-3F0ED6F82067";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_71DF27D5-F356-4C1E-BE29-D2F16CC6D88F";
    private static final String EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID = "_816018AD-B9D9-4F19-B713-547E8A822AC5";
    private static final String FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID = "_FBAD5555-D73B-4AD8-9C41-34B6B8593DAE";
    private static final String EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "_B343D66C-61C6-4FB6-BFF7-8B914DB3FED7";
    private static final String FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "_BCD0A0C2-F936-48BC-B612-F99BE773E8EF";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 28;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Escalation event01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escalation01";
        String EVENT_DATA_OUTPUT = "||output:String||[dout]output->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 28);
        IntermediateEscalationEvent filledTopEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "Escalation event01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledTopEvent.getExecutionSet(), "escalation01", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopEvent.getDataIOSet(), "||output:String||[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 28);
        IntermediateEscalationEvent emptyTopEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertEscalationEventExecutionSet(emptyTopEvent.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptyTopEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Escalation event03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escalation03";
        String EVENT_DATA_OUTPUT = "||output:String||[dout]output->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 28);
        IntermediateEscalationEvent filledSubprocessEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Escalation event03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "escalation03", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||output:String||[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 28);
        IntermediateEscalationEvent emptySubprocessEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertEscalationEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "Escalation event02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escalation02";
        String EVENT_DATA_OUTPUT = "||output:String||[dout]output->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 28);
        IntermediateEscalationEvent filledSubprocessEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID, false, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Escalation event02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "escalation02", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||output:String||[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 28);
        IntermediateEscalationEvent emptyEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID, false, 2);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertEscalationEventExecutionSet(emptyEvent.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptyEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 28);
        IntermediateEscalationEvent emptySubprocessEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, false, 2);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertEscalationEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "Escalation event04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escalation04";
        String EVENT_DATA_OUTPUT = "||output:String||[dout]output->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 28);
        IntermediateEscalationEvent filledSubprocessEvent = (IntermediateEscalationEvent)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, false, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Escalation event04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "escalation04", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||output:String||[dout]output->processGlobalVar");
    }

    @Override
    String getBpmnCatchingIntermediateEventFilePath() {
        return BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateEscalationEvent> getCatchingIntermediateEventType() {
        return IntermediateEscalationEvent.class;
    }

    @Override
    String[] getFilledTopLevelEventIds() {
        return new String[]{FILLED_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventIds() {
        return new String[]{FILLED_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledTopLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertEscalationEventExecutionSet(CancellingEscalationEventExecutionSet executionSet, String escalationRef, boolean isCancelling, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getEscalationRef()).isNotNull();
        Assertions.assertThat((String)executionSet.getEscalationRef().getValue()).isEqualTo((Object)escalationRef);
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }
}

