/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.workitem;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.jbpm.process.core.ParameterDefinition;
import org.jbpm.process.core.datatype.impl.type.StringDataType;
import org.jbpm.process.core.impl.ParameterDefinitionImpl;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.WorkItemDefinitionParser;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.service.WorkItemDefinitionRemoteService;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkItemDefinitionParserTest {
    private static final String WID_EMAIL = "org/kie/workbench/common/stunner/bpmn/backend/workitem/Email.wid";
    private static final String WID_FTP = "org/kie/workbench/common/stunner/bpmn/backend/workitem/FTP.wid";
    private static final String NAME = "name1";
    private static final String CATWGORY = "cat1";
    private static final String DESC = "desc1";
    private static final String DISPLAY_NAME = "dn1";
    private static final String DOC = "doc1";
    private static final String HANDLER = "org.hander1";
    private static final String PATH = "path1";
    private static final String ICON = "icon1";
    private static final String ICON_PATH = "path1/icon1";
    private static final String ICON_DATA = "iconData1";
    @Mock
    private WorkDefinitionImpl jbpmWorkDefinition;
    @Mock
    private ParameterDefinitionImpl param1;
    @Mock
    private ParameterDefinitionImpl param2;
    @Mock
    private Function<String, String> dataUriProvider;
    private static final String JBOSS_REPO = "https://docs.jboss.org/jbpm/v6.0/repository";

    @Before
    public void init() {
        Mockito.when((Object)this.jbpmWorkDefinition.getName()).thenReturn((Object)NAME);
        Mockito.when((Object)this.jbpmWorkDefinition.getCategory()).thenReturn((Object)CATWGORY);
        Mockito.when((Object)this.jbpmWorkDefinition.getDescription()).thenReturn((Object)DESC);
        Mockito.when((Object)this.jbpmWorkDefinition.getDisplayName()).thenReturn((Object)DISPLAY_NAME);
        Mockito.when((Object)this.jbpmWorkDefinition.getDocumentation()).thenReturn((Object)DOC);
        Mockito.when((Object)this.jbpmWorkDefinition.getDefaultHandler()).thenReturn((Object)HANDLER);
        Mockito.when((Object)this.jbpmWorkDefinition.getPath()).thenReturn((Object)PATH);
        Mockito.when((Object)this.jbpmWorkDefinition.getIcon()).thenReturn((Object)ICON);
        Mockito.when((Object)this.dataUriProvider.apply((String)Matchers.eq((Object)ICON_PATH))).thenReturn((Object)ICON_DATA);
        Mockito.when((Object)this.param1.getName()).thenReturn((Object)"param1");
        Mockito.when((Object)this.param1.getType()).thenReturn((Object)new StringDataType());
        Mockito.when((Object)this.param2.getName()).thenReturn((Object)"param2");
        Mockito.when((Object)this.param2.getType()).thenReturn((Object)new StringDataType());
        HashSet<ParameterDefinition> parameters = new HashSet<ParameterDefinition>(2){
            {
                this.add(WorkItemDefinitionParserTest.this.param1);
                this.add(WorkItemDefinitionParserTest.this.param2);
            }
        };
        Mockito.when((Object)this.jbpmWorkDefinition.getParameters()).thenReturn((Object)parameters);
    }

    @Test
    public void testParseJBPMWorkDefinition() {
        WorkItemDefinition workItemDefinition = WorkItemDefinitionParser.parse((WorkDefinitionImpl)this.jbpmWorkDefinition, w -> "uri", this.dataUriProvider);
        Assert.assertNotNull((Object)workItemDefinition);
        Assert.assertEquals((Object)NAME, (Object)workItemDefinition.getName());
        Assert.assertEquals((Object)CATWGORY, (Object)workItemDefinition.getCategory());
        Assert.assertEquals((Object)DESC, (Object)workItemDefinition.getDescription());
        Assert.assertEquals((Object)DISPLAY_NAME, (Object)workItemDefinition.getDisplayName());
        Assert.assertEquals((Object)DOC, (Object)workItemDefinition.getDocumentation());
        Assert.assertEquals((Object)HANDLER, (Object)workItemDefinition.getDefaultHandler());
        Assert.assertEquals((Object)ICON_DATA, (Object)workItemDefinition.getIconDefinition().getIconData());
        Assert.assertEquals((Object)"|param1:String,param2:String|", (Object)workItemDefinition.getParameters());
        Assert.assertEquals((Object)"||", (Object)workItemDefinition.getResults());
    }

    @Test
    public void testEmailWorkItemDefinition() throws Exception {
        Mockito.when((Object)this.dataUriProvider.apply((String)Matchers.eq((Object)"email.gif"))).thenReturn((Object)ICON_DATA);
        String raw = WorkItemDefinitionParserTest.loadStream(WID_EMAIL);
        Collection workItemDefinitions = WorkItemDefinitionParser.parse((String)raw, w -> "uri", this.dataUriProvider);
        Assert.assertNotNull((Object)workItemDefinitions);
        Assert.assertEquals((long)1L, (long)workItemDefinitions.size());
        WorkItemDefinition workItemDefinition = (WorkItemDefinition)workItemDefinitions.iterator().next();
        Assert.assertNotNull((Object)workItemDefinition);
        Assert.assertEquals((Object)"Email", (Object)workItemDefinition.getName());
        Assert.assertEquals((Object)"Communication", (Object)workItemDefinition.getCategory());
        Assert.assertEquals((Object)"Sending emails", (Object)workItemDefinition.getDescription());
        Assert.assertEquals((Object)"Email", (Object)workItemDefinition.getDisplayName());
        Assert.assertEquals((Object)"index.html", (Object)workItemDefinition.getDocumentation());
        Assert.assertEquals((Object)"org.jbpm.process.workitem.email.EmailWorkItemHandler", (Object)workItemDefinition.getDefaultHandler());
        Assert.assertEquals((Object)ICON_DATA, (Object)workItemDefinition.getIconDefinition().getIconData());
        Assert.assertEquals((Object)"|Body:String,From:String,Subject:String,To:String|", (Object)workItemDefinition.getParameters());
        Assert.assertEquals((Object)"||", (Object)workItemDefinition.getResults());
    }

    @Test
    public void testFTPWorkItemDefinition() throws Exception {
        Mockito.when((Object)this.dataUriProvider.apply((String)Matchers.eq((Object)"ftp.gif"))).thenReturn((Object)ICON_DATA);
        String raw = WorkItemDefinitionParserTest.loadStream(WID_FTP);
        Collection workItemDefinitions = WorkItemDefinitionParser.parse((String)raw, w -> "uri", this.dataUriProvider);
        Assert.assertNotNull((Object)workItemDefinitions);
        Assert.assertEquals((long)1L, (long)workItemDefinitions.size());
        WorkItemDefinition workItemDefinition = (WorkItemDefinition)workItemDefinitions.iterator().next();
        Assert.assertNotNull((Object)workItemDefinition);
        Assert.assertEquals((Object)"FTP", (Object)workItemDefinition.getName());
        Assert.assertEquals((Object)"File System", (Object)workItemDefinition.getCategory());
        Assert.assertEquals((Object)"Sending files using FTP", (Object)workItemDefinition.getDescription());
        Assert.assertEquals((Object)"FTP", (Object)workItemDefinition.getDisplayName());
        Assert.assertEquals((Object)"", (Object)workItemDefinition.getDocumentation());
        Assert.assertEquals((Object)"org.jbpm.process.workitem.ftp.FTPUploadWorkItemHandler", (Object)workItemDefinition.getDefaultHandler());
        Assert.assertEquals((Object)ICON_DATA, (Object)workItemDefinition.getIconDefinition().getIconData());
        Assert.assertEquals((Object)"|Body:String,FilePath:String,Password:String,User:String|", (Object)workItemDefinition.getParameters());
        Assert.assertEquals((Object)"||", (Object)workItemDefinition.getResults());
    }

    public static String loadStream(String path) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(path), (Writer)writer, (String)WorkItemDefinitionParser.ENCODING);
        return writer.toString();
    }

    public static void main(String[] args) {
        WorkItemDefinitionParserTest.testServiceRepository();
    }

    private static void testServiceRepository() {
        System.out.println("Starting...");
        Collection workItems = WorkItemDefinitionRemoteService.fetch((Function)WorkItemDefinitionRemoteService.DEFAULT_LOOKUP_SERVICE, (String)JBOSS_REPO, (String[])new String[]{"Email"});
        System.out.println("Completed!");
        WorkItemDefinition workItemDefinition = (WorkItemDefinition)workItems.iterator().next();
        Assert.assertNotNull((Object)workItemDefinition);
        Assert.assertEquals((Object)"Email", (Object)workItemDefinition.getName());
        Assert.assertEquals((Object)"Communication", (Object)workItemDefinition.getCategory());
        Assert.assertEquals((Object)"Sending emails", (Object)workItemDefinition.getDescription());
        Assert.assertEquals((Object)"Email", (Object)workItemDefinition.getDisplayName());
        Assert.assertEquals((Object)"index.html", (Object)workItemDefinition.getDocumentation());
        Assert.assertEquals((Object)"org.jbpm.process.workitem.email.EmailWorkItemHandler", (Object)workItemDefinition.getDefaultHandler());
        Assert.assertEquals((Object)"|Body:String,From:String,Subject:String,To:String|", (Object)workItemDefinition.getParameters());
        Assert.assertEquals((Object)"||", (Object)workItemDefinition.getResults());
        Assert.assertNotNull((Object)workItemDefinition.getIconDefinition().getIconData());
    }
}

