/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.Collection;
import java.util.List;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.codegen.feel11.ProcessedExpression;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.CompiledExpressionImpl;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.lang.impl.FEELImpl;

public class DMNLiteralExpressionEvaluator
implements DMNExpressionEvaluator {
    private CompiledExpression expression;
    private boolean isFunctionDef;

    public DMNLiteralExpressionEvaluator(CompiledExpression expression) {
        this.expression = expression;
        if (expression instanceof CompiledExpressionImpl) {
            this.isFunctionDef = ((CompiledExpressionImpl)expression).isFunctionDef();
        } else if (expression instanceof ProcessedExpression) {
            this.isFunctionDef = ((ProcessedExpression)expression).getInterpreted().isFunctionDef();
        } else {
            throw new IllegalArgumentException("Cannot create DMNLiteralExpressionEvaluator: unsupported type " + expression.getClass());
        }
    }

    public boolean isFunctionDefinition() {
        return this.isFunctionDef;
    }

    public CompiledExpression getExpression() {
        return this.expression;
    }

    @Override
    public EvaluatorResult evaluate(DMNRuntimeEventManager dmrem, DMNResult result) {
        List<DMNProfile> profiles = ((DMNRuntimeImpl)dmrem.getRuntime()).getProfiles();
        FEELImpl feelInstance = (FEELImpl)FEEL.newInstance((ClassLoader)dmrem.getRuntime().getRootClassLoader(), profiles);
        EvaluationContextImpl ectx = feelInstance.newEvaluationContext((Collection)dmrem.getListeners(), result.getContext().getAll());
        ectx.setDMNRuntime(dmrem.getRuntime());
        Object val = feelInstance.evaluate(this.expression, (EvaluationContext)ectx);
        return new EvaluatorResultImpl(val, EvaluatorResult.ResultType.SUCCESS);
    }
}

