/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.services.api.KieControllerNotConnectedException;
import org.kie.server.services.api.KieControllerNotDefinedException;
import org.kie.server.services.api.StartupStrategy;
import org.kie.server.services.impl.ContainerManager;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.controller.ControllerConnectRunnable;
import org.kie.server.services.impl.storage.KieServerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalContainersStartupStrategy
implements StartupStrategy {
    private static final Logger logger = LoggerFactory.getLogger(LocalContainersStartupStrategy.class);

    @Override
    public void startup(KieServerImpl kieServer, ContainerManager containerManager, KieServerState currentState, AtomicBoolean kieServerActive) {
        Set<KieContainerResource> containers = this.prepareContainers(currentState.getContainers());
        containerManager.installContainersSync(kieServer, containers, currentState, new KieServerSetup());
        KieServerController kieController = kieServer.getController();
        KieServerInfo kieServerInfo = kieServer.getInfoInternal();
        try {
            kieController.connect(kieServerInfo);
        }
        catch (KieControllerNotDefinedException kieControllerNotDefinedException) {
        }
        catch (KieControllerNotConnectedException e) {
            logger.warn("Unable to connect to any controllers, delaying container installation until connection can be established");
            Thread connectToControllerThread = new Thread((Runnable)new ControllerConnectRunnable(kieServerActive, kieController, kieServerInfo, currentState, new ContainerManager(){

                @Override
                public void installContainers(KieServerImpl kieServer, Set<KieContainerResource> containers, KieServerState currentState, KieServerSetup kieServerSetup) {
                }

                @Override
                public void installContainersSync(KieServerImpl kieServer, Set<KieContainerResource> containers, KieServerState currentState, KieServerSetup kieServerSetup) {
                }
            }, kieServer, this), "KieServer-ControllerConnect");
            connectToControllerThread.start();
        }
    }

    public String toString() {
        return "LocalContainersStartupStrategy - deploys only locally (in server state file) kie containers, ignores kie containers given by controller";
    }
}

