/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.adapter;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.MorphAdapter;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.definition.morph.MorphProperty;
import org.kie.workbench.common.stunner.core.definition.morph.PropertyMorphDefinition;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

public abstract class AbstractMorphAdapter<S>
implements MorphAdapter<S> {
    protected DefinitionUtils definitionUtils;
    protected FactoryManager factoryManager;
    protected final List<MorphDefinition> morphDefinitions = new LinkedList<MorphDefinition>();

    public AbstractMorphAdapter(DefinitionUtils definitionUtils, FactoryManager factoryManager) {
        this.definitionUtils = definitionUtils;
        this.factoryManager = factoryManager;
    }

    protected abstract <T> T doMerge(S var1, MorphDefinition var2, T var3);

    public <T> Iterable<MorphDefinition> getMorphDefinitions(T definition) {
        if (null != definition && this.hasMorphDefinitions()) {
            String[] ids = this.getDefinitionIds(definition);
            String definitionId = ids[0];
            String baseId = ids[1];
            return this.getMorphDefinitions(definitionId, baseId);
        }
        return null;
    }

    public Iterable<MorphDefinition> getMorphDefinitions(String id, String baseId) {
        if (null != id) {
            LinkedList<MorphDefinition> result = new LinkedList<MorphDefinition>();
            for (MorphDefinition morphDefinition : this.morphDefinitions) {
                if (!morphDefinition.accepts(id) && (null == baseId || !morphDefinition.accepts(baseId))) continue;
                result.add(morphDefinition);
            }
            return result;
        }
        return null;
    }

    public <T> Iterable<MorphProperty> getMorphProperties(T definition) {
        if (null != definition && this.hasMorphDefinitions()) {
            String[] ids = this.getDefinitionIds(definition);
            String definitionId = ids[0];
            String baseId = ids[1];
            return this.getMorphProperties(definitionId, baseId);
        }
        return null;
    }

    protected Iterable<MorphProperty> getMorphProperties(String definitionId, String baseId) {
        if (null != definitionId) {
            LinkedList<MorphProperty> result = new LinkedList<MorphProperty>();
            for (MorphDefinition morphDefinition : this.morphDefinitions) {
                boolean acceptsDefinition = morphDefinition.accepts(definitionId) || null != baseId && morphDefinition.accepts(baseId);
                if (!acceptsDefinition || !(morphDefinition instanceof PropertyMorphDefinition)) continue;
                PropertyMorphDefinition propertyMorphDefinition = (PropertyMorphDefinition)morphDefinition;
                Iterable morphProperties = propertyMorphDefinition.getMorphProperties(definitionId);
                this.addAll(result, morphProperties);
                Iterable baseMorphProperties = null != baseId ? propertyMorphDefinition.getMorphProperties(definitionId) : null;
                if (null == baseMorphProperties) continue;
                this.addAll(result, baseMorphProperties);
            }
            return result;
        }
        return null;
    }

    public <T> Iterable<String> getTargets(T definition, MorphDefinition morphDefinition) {
        String[] ids = this.definitionUtils.getDefinitionIds(definition);
        String definitionId = ids[0];
        String baseId = ids[1];
        return this.getTargets(definition.getClass(), definitionId, baseId);
    }

    protected Iterable<String> getTargets(Class<?> type, String definitionId, String baseId) {
        if (null != definitionId) {
            LinkedList<String> result = new LinkedList<String>();
            for (MorphDefinition morphDefinition : this.morphDefinitions) {
                boolean acceptsDefinition = morphDefinition.accepts(definitionId) || null != baseId && morphDefinition.accepts(baseId);
                if (!acceptsDefinition) continue;
                Iterable t1 = morphDefinition.getTargets(definitionId);
                this.addAll(result, t1);
                if (null == baseId) continue;
                Iterable t2 = morphDefinition.getTargets(baseId);
                this.addAll(result, t2);
            }
            return result;
        }
        return null;
    }

    public <T> T morph(S source, MorphDefinition morphDefinition, String targetId) {
        if (null == source) {
            throw new IllegalArgumentException("Cannot morph from unspecified source.");
        }
        if (null == morphDefinition) {
            throw new IllegalArgumentException("Cannot morph from unspecified Morph Definition.");
        }
        if (null == targetId) {
            throw new IllegalArgumentException("Cannot morph to unspecified target.");
        }
        Object target = this.factoryManager.newDefinition(targetId);
        if (null == target) {
            throw new RuntimeException("Morph failed. Cannot build a Definition instance for [" + targetId + "]");
        }
        return (T)this.doMerge(source, morphDefinition, target);
    }

    protected <T> String[] getDefinitionIds(T definition) {
        return this.definitionUtils.getDefinitionIds(definition);
    }

    protected DefinitionManager getDefinitionManager() {
        return this.definitionUtils.getDefinitionManager();
    }

    protected <T> void addAll(Collection<T> source, Iterable<T> values) {
        if (null != values && values.iterator().hasNext()) {
            for (T value : values) {
                source.add(value);
            }
        }
    }

    protected boolean contains(Iterable<String> iterable, String value) {
        if (null != iterable && iterable.iterator().hasNext()) {
            for (String v : iterable) {
                if (!value.equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasMorphDefinitions() {
        return !this.morphDefinitions.isEmpty();
    }
}

