/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.registry.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.registry.impl.DefinitionsCacheRegistry;

@Dependent
@Typed(value={DefaultDefinitionsCacheRegistry.class})
public class DefaultDefinitionsCacheRegistry
implements DefinitionsCacheRegistry {
    private final FactoryManager factoryManager;
    private final AdapterManager adapterManager;
    private Map<String, DefinitionHolder> definitionsById;
    private Map<String, DefinitionHolder> definitionsByType;

    @Inject
    public DefaultDefinitionsCacheRegistry(FactoryManager factoryManager, AdapterManager adapterManager) {
        this.factoryManager = factoryManager;
        this.adapterManager = adapterManager;
    }

    public DefaultDefinitionsCacheRegistry useStorage(Supplier<Map<String, ?>> storageSupplier) {
        this.definitionsById = storageSupplier.get();
        this.definitionsByType = storageSupplier.get();
        return this;
    }

    public Object getDefinitionById(String id) {
        return this.getDefinitionHolder(id).instance;
    }

    private DefinitionHolder getDefinitionHolder(String id) {
        DefinitionHolder holder = this.definitionsById.get(id);
        if (null == holder) {
            holder = this.registerInstance(this.factoryManager.newDefinition(id));
        }
        return holder;
    }

    public void clear() {
        this.definitionsById.clear();
        this.definitionsByType.clear();
    }

    public void register(Object instance) {
        this.registerInstance(instance);
    }

    public boolean remove(Object instance) {
        Class<?> type = instance.getClass();
        DefinitionAdapter<Object> adapter = this.getAdapter(type);
        String id = adapter.getId(instance).value();
        this.definitionsByType.remove(type.getName());
        return null != this.definitionsById.remove(id);
    }

    public boolean contains(Object instance) {
        Class<?> type = instance.getClass();
        DefinitionAdapter<Object> adapter = this.getAdapter(type);
        String id = adapter.getId(instance).value();
        return this.definitionsById.containsKey(id);
    }

    public boolean isEmpty() {
        return this.definitionsById.isEmpty();
    }

    @PreDestroy
    public void destroy() {
        this.clear();
        this.definitionsById = null;
        this.definitionsByType = null;
    }

    @Override
    public Set<String> getLabels(String id) {
        return this.getDefinitionHolder(id).labels;
    }

    private DefinitionHolder registerInstance(Object instance) {
        Class<?> type = instance.getClass();
        DefinitionAdapter<Object> adapter = this.getAdapter(type);
        String id = adapter.getId(instance).value();
        Set labels = adapter.getLabels(instance);
        DefinitionHolder holder = new DefinitionHolder(instance, labels);
        this.definitionsById.put(id, holder);
        this.definitionsByType.put(type.getName(), holder);
        return holder;
    }

    private DefinitionAdapter<Object> getAdapter(Class<?> type) {
        return this.adapterManager.registry().getDefinitionAdapter(type);
    }

    private static class DefinitionHolder {
        private final Object instance;
        private final Set<String> labels;

        private DefinitionHolder(Object instance, Set<String> labels) {
            this.instance = instance;
            this.labels = new HashSet<String>(labels);
        }
    }
}

