/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.morph;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.kie.workbench.common.stunner.core.definition.morph.BindableMorphDefinition;
import org.kie.workbench.common.stunner.core.definition.morph.BindableMorphProperty;
import org.kie.workbench.common.stunner.core.definition.morph.MorphProperty;
import org.kie.workbench.common.stunner.core.definition.morph.PropertyMorphDefinition;

public abstract class BindablePropertyMorphDefinition
extends BindableMorphDefinition
implements PropertyMorphDefinition {
    protected abstract Map<Class<?>, Collection<MorphProperty>> getBindableMorphProperties();

    @Override
    public Iterable<MorphProperty> getMorphProperties(String definitionId) {
        Class<?> type = this.getSourceType(definitionId);
        return this.getMorphPropertiesForType(type);
    }

    public Iterable<MorphProperty> getMorphPropertiesForType(Class<?> type) {
        if (null != type) {
            return this.getBindableMorphProperties().get(type);
        }
        return null;
    }

    @Override
    protected Map<Class<?>, Collection<Class<?>>> getDomainMorphs() {
        if (null != this.getBindableMorphProperties() && !this.getBindableMorphProperties().isEmpty()) {
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry<Class<?>, Collection<MorphProperty>> entry : this.getBindableMorphProperties().entrySet()) {
                Class<?> sourceType = entry.getKey();
                Collection<MorphProperty> pms = entry.getValue();
                for (MorphProperty pm : pms) {
                    BindableMorphProperty morphProperty = (BindableMorphProperty)pm;
                    LinkedList targets = (LinkedList)result.get(sourceType);
                    if (null == targets) {
                        targets = new LinkedList();
                        result.put(sourceType, targets);
                    }
                    targets.addAll(morphProperty.getMorphTargetClasses().values());
                }
            }
            return result;
        }
        return null;
    }
}

