/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.ThrowingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageEventExecutionSet;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class ThrowingIntermediateMessageEventTest
extends ThrowingIntermediateEventTest<IntermediateMessageEventThrowing> {
    private static final String BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/throwingIntermediateMessageEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "560D560D-5A7B-4904-830D-BA7757A09EEC";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "A7B54476-6EDE-4091-ABF5-B4CE92641825";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "882E78A5-450C-4BE1-9F7E-4F61367F257C";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "252328FA-FA08-42B0-BD60-971A94DFA755";
    private static final String EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID = "A38272BC-35C4-4F28-808C-08E3B6969BBE";
    private static final String FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID = "5CD4BF0B-AD61-4DBD-B08D-C8B0F7364BE0";
    private static final String EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "ACF512B7-D95D-42F0-99E2-8427F2B23D49";
    private static final String FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "A893CEAD-3027-447F-84A6-F33679EFD770";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 23;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "message01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "message01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "message01";
        String EVENT_DATA_INPUT = "message01:String||||[din]ProcessGlobalVar->message01";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventThrowing filledTopEvent = (IntermediateMessageEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "message01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "message01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMessageEventExecutionSet(filledTopEvent.getExecutionSet(), "message01");
        this.assertDataIOSet(filledTopEvent.getDataIOSet(), "message01:String||||[din]ProcessGlobalVar->message01");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventThrowing emptyTopEvent = (IntermediateMessageEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptyTopEvent.getExecutionSet(), "");
        this.assertDataIOSet(emptyTopEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "message03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "message03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "message03";
        String EVENT_DATA_INPUT = "message03:String||||[din]ProcessGlobalVar->message03";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventThrowing filledSubprocessEvent = (IntermediateMessageEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "message03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "message03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMessageEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "message03");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "message03:String||||[din]ProcessGlobalVar->message03");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventThrowing emptySubprocessEvent = (IntermediateMessageEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "message02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "message02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "message02";
        String EVENT_DATA_INPUT = "message02:String||||[din]ProcessGlobalVar->message02";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventThrowing filledSubprocessEvent = (IntermediateMessageEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "message02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "message02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMessageEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "message02");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "message02:String||||[din]ProcessGlobalVar->message02");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventThrowing emptyEvent = (IntermediateMessageEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptyEvent.getExecutionSet(), "");
        this.assertDataIOSet(emptyEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventThrowing emptySubprocessEvent = (IntermediateMessageEventThrowing)this.getThrowingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertMessageEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "message04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "message04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "message04";
        String EVENT_DATA_INPUT = "message04:String||||[din]ProcessGlobalVar->message04";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        IntermediateMessageEventThrowing filledSubprocessEvent = (IntermediateMessageEventThrowing)this.getThrowingIntermediateNodeById(diagram, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, true, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "message04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "message04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMessageEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "message04");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "message04:String||||[din]ProcessGlobalVar->message04");
    }

    @Override
    String getBpmnThrowingIntermediateEventFilePath() {
        return BPMN_THROWING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateMessageEventThrowing> getThrowingIntermediateEventType() {
        return IntermediateMessageEventThrowing.class;
    }

    @Override
    String[] getFilledTopLevelEventIds() {
        return new String[]{FILLED_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventIds() {
        return new String[]{FILLED_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledTopLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertMessageEventExecutionSet(MessageEventExecutionSet executionSet, String messageReference) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getMessageRef()).isNotNull();
        Assertions.assertThat((String)executionSet.getMessageRef().getValue()).isEqualTo(messageReference);
    }
}

