/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.simulation;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.jbpm.simulation.SimulationRepository;
import org.jbpm.simulation.SimulationRunner;
import org.jbpm.simulation.impl.WorkingMemorySimulationRepository;
import org.junit.Assert;
import org.junit.Test;

public class SimulationRunnerTest {
    @Test
    public void testRunSimulationOnSendTask() throws Exception {
        String bpsimSendTaskSource = this.readFile("BPSim_sendtask.bpmn2");
        String bpsimSendTaskProcessId = "evaluation.simtest";
        WorkingMemorySimulationRepository wmsRepo = this.runSimulation(bpsimSendTaskProcessId, bpsimSendTaskSource, 50, 5L);
        Assert.assertNotNull((Object)wmsRepo);
        Assert.assertNotNull((Object)wmsRepo.getAggregatedEvents());
        Assert.assertTrue((wmsRepo.getAggregatedEvents().size() > 0 ? 1 : 0) != 0);
    }

    private WorkingMemorySimulationRepository runSimulation(String processId, String processXML, int numInstances, long interval) {
        SimulationRepository repo = SimulationRunner.runSimulation((String)processId, (String)processXML, (int)numInstances, (long)interval, (boolean)true, (String[])new String[]{"onevent.simulation.rules.drl"});
        return (WorkingMemorySimulationRepository)repo;
    }

    private String readFile(String fileName) throws Exception {
        URL fileURL = SimulationRunnerTest.class.getResource(fileName);
        return new String(Files.readAllBytes(Paths.get(fileURL.toURI())));
    }
}

