/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.backend.service;

import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.backend.service.KieServiceOverviewLoader;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.service.DefinitionSetService;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.registry.BackendRegistryFactory;
import org.kie.workbench.common.stunner.project.backend.service.ProjectDiagramServiceController;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class ProjectDiagramServiceImpl
extends KieService<ProjectDiagram>
implements ProjectDiagramService {
    private static final Logger LOG = LoggerFactory.getLogger((String)ProjectDiagramServiceImpl.class.getName());
    private final SessionInfo sessionInfo;
    private final Event<ResourceOpenedEvent> resourceOpenedEvent;
    private final CommentedOptionFactory commentedOptionFactory;
    private final ProjectDiagramServiceController controller;

    protected ProjectDiagramServiceImpl() {
        this(null, null, null, null, null, null, null, null, null, null);
    }

    @Inject
    public ProjectDiagramServiceImpl(DefinitionManager definitionManager, FactoryManager factoryManager, Instance<DefinitionSetService> definitionSetServiceInstances, BackendRegistryFactory registryFactory, @Named(value="ioStrategy") IOService ioService, SessionInfo sessionInfo, Event<ResourceOpenedEvent> resourceOpenedEvent, CommentedOptionFactory commentedOptionFactory, KieModuleService moduleService, KieServiceOverviewLoader overviewLoader) {
        this.ioService = ioService;
        this.sessionInfo = sessionInfo;
        this.resourceOpenedEvent = resourceOpenedEvent;
        this.commentedOptionFactory = commentedOptionFactory;
        this.controller = this.buildController(definitionManager, factoryManager, definitionSetServiceInstances, registryFactory, ioService, moduleService, overviewLoader);
    }

    @PostConstruct
    public void init() {
        this.controller.initialize();
    }

    public ProjectDiagram getDiagramByPath(Path path) {
        return this.controller.getDiagramByPath(path);
    }

    public boolean accepts(Path path) {
        return this.controller.accepts(path);
    }

    public Path create(Path path, String name, String defSetId, String projectName, Package projectPkg, Optional<String> projectType) {
        return this.controller.create(path, name, defSetId, projectName, projectPkg, projectType);
    }

    public Path create(Path path, String name, String defSetId) {
        return this.controller.create(path, name, defSetId);
    }

    protected ProjectDiagram constructContent(Path path, Overview overview) {
        ProjectDiagram diagram = this.getDiagramByPath(path);
        if (null != diagram) {
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.sessionInfo));
            return diagram;
        }
        LOG.error("Failed to construct diagram content for path [" + path + "].");
        return null;
    }

    public Path save(Path path, ProjectDiagram content, Metadata metadata, String comment) {
        LOG.debug("Saving diagram with UUID [" + content.getName() + "] into path [" + path + "].");
        return this.controller.save(path, content, this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
    }

    public Path saveAsXml(Path path, String xml, Metadata metadata, String comment) {
        LOG.debug("Saving diagram as XML into path [" + path + "].");
        return this.controller.saveAsXml(path, xml, this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
    }

    public ProjectMetadata saveOrUpdate(ProjectDiagram diagram) {
        return (ProjectMetadata)this.controller.saveOrUpdate((Diagram)diagram);
    }

    public Path saveOrUpdateSvg(Path diagramPath, String rawDiagramSvg) {
        return this.controller.saveOrUpdateSvg(diagramPath, rawDiagramSvg);
    }

    public boolean delete(ProjectDiagram diagram) {
        return this.controller.delete((Diagram)diagram);
    }

    public void delete(Path path, String comment) {
        this.controller.delete(path, comment);
    }

    public String getRawContent(ProjectDiagram diagram) {
        return this.controller.getRawContent((Diagram)diagram);
    }

    protected ProjectDiagramServiceController buildController(DefinitionManager definitionManager, FactoryManager factoryManager, Instance<DefinitionSetService> definitionSetServiceInstances, BackendRegistryFactory registryFactory, IOService ioService, KieModuleService moduleService, KieServiceOverviewLoader overviewLoader) {
        return new ProjectDiagramServiceController(definitionManager, factoryManager, definitionSetServiceInstances, ioService, registryFactory, moduleService, overviewLoader);
    }
}

