/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.internal.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.drools.core.builder.conf.impl.ResourceConfigurationImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.io.impl.ClassPathResource;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.assembler.DMNAssemblerService;
import org.kie.dmn.core.assembler.DMNResource;
import org.kie.dmn.core.assembler.DMNResourceDependenciesSorter;
import org.kie.dmn.core.compiler.DMNCompilerConfigurationImpl;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.compiler.RuntimeTypeCheckOption;
import org.kie.dmn.core.compiler.profiles.ExtendedDMNProfile;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.core.impl.DMNRuntimeKB;
import org.kie.dmn.feel.util.Either;
import org.kie.dmn.model.api.Definitions;
import org.kie.internal.io.ResourceWithConfigurationImpl;

public class DMNRuntimeBuilder {
    private final DMNRuntimeBuilderCtx ctx = new DMNRuntimeBuilderCtx();

    private DMNRuntimeBuilder() {
    }

    public static DMNRuntimeBuilder fromDefaults() {
        DMNRuntimeBuilder dmnRuntimeBuilder = new DMNRuntimeBuilder();
        dmnRuntimeBuilder.addProfile(new ExtendedDMNProfile());
        return dmnRuntimeBuilder;
    }

    public DMNRuntimeBuilder addProfile(DMNProfile dmnProfile) {
        this.ctx.dmnProfiles.add(dmnProfile);
        this.ctx.cc.addExtensions(dmnProfile.getExtensionRegisters());
        this.ctx.cc.addDRGElementCompilers(dmnProfile.getDRGElementCompilers());
        this.ctx.cc.addFEELProfile(dmnProfile);
        return this;
    }

    public DMNRuntimeBuilder setOption(RuntimeTypeCheckOption option) {
        this.ctx.cc.setProperty(option.getPropertyName(), "" + option.isRuntimeTypeCheck());
        return this;
    }

    public DMNRuntimeBuilder setRootClassLoader(ClassLoader classLoader) {
        this.ctx.cc.setRootClassLoader(classLoader);
        return this;
    }

    public static DMNRuntimeBuilderConfigured usingStrict() {
        DMNRuntimeBuilder dmnRuntimeBuilder = new DMNRuntimeBuilder();
        dmnRuntimeBuilder.setRootClassLoader(null);
        dmnRuntimeBuilder.setOption(new RuntimeTypeCheckOption(true));
        return dmnRuntimeBuilder.buildConfiguration();
    }

    public DMNRuntimeBuilderConfigured buildConfiguration() {
        DMNCompilerImpl dmnCompiler = new DMNCompilerImpl(this.ctx.cc);
        return new DMNRuntimeBuilderConfigured(this.ctx, dmnCompiler);
    }

    private static class DMNRuntimeKBStatic
    implements DMNRuntimeKB {
        private final List<DMNProfile> dmnProfiles;
        private final List<DMNModel> models;

        private DMNRuntimeKBStatic(Collection<DMNModel> models, Collection<DMNProfile> dmnProfiles) {
            this.models = Collections.unmodifiableList(new ArrayList<DMNModel>(models));
            this.dmnProfiles = Collections.unmodifiableList(new ArrayList<DMNProfile>(dmnProfiles));
        }

        @Override
        public List<DMNModel> getModels() {
            return this.models;
        }

        @Override
        public DMNModel getModel(String namespace, String modelName) {
            return this.models.stream().filter(m -> m.getNamespace().equals(namespace) && m.getName().equals(modelName)).findFirst().orElse(null);
        }

        @Override
        public DMNModel getModelById(String namespace, String modelId) {
            return this.models.stream().filter(m -> m.getNamespace().equals(namespace) && m.getDefinitions().getId().equals(modelId)).findFirst().orElse(null);
        }

        @Override
        public List<DMNProfile> getProfiles() {
            return this.dmnProfiles;
        }

        @Override
        public List<DMNRuntimeEventListener> getListeners() {
            return Collections.emptyList();
        }

        @Override
        public ClassLoader getRootClassLoader() {
            return null;
        }

        @Override
        public InternalKnowledgeBase getInternalKnowledgeBase() {
            throw new UnsupportedOperationException();
        }
    }

    public static class DMNRuntimeBuilderConfigured {
        private final DMNRuntimeBuilderCtx ctx;
        private final DMNCompilerImpl dmnCompiler;

        private DMNRuntimeBuilderConfigured(DMNRuntimeBuilderCtx ctx, DMNCompilerImpl dmnCompiler) {
            this.ctx = ctx;
            this.dmnCompiler = dmnCompiler;
        }

        public Either<Exception, DMNRuntime> fromClasspathResource(String resourceName, Class<?> testClass) {
            return this.fromResources(Arrays.asList(new ClassPathResource(resourceName, testClass)));
        }

        public Either<Exception, DMNRuntime> fromClasspathResources(String resourceName, Class<?> testClass, String ... additionalResources) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.add((Resource)new ClassPathResource(resourceName, testClass));
            for (String ar : additionalResources) {
                resources.add((Resource)new ClassPathResource(ar, testClass));
            }
            return this.fromResources(resources);
        }

        public Either<Exception, DMNRuntime> fromResources(Collection<Resource> resources) {
            ArrayList<DMNResource> dmnResources = new ArrayList<DMNResource>();
            for (Resource r : resources) {
                Definitions definitions;
                try {
                    definitions = this.dmnCompiler.getMarshaller().unmarshal(r.getReader());
                }
                catch (IOException e) {
                    return Either.ofLeft((Object)e);
                }
                ResourceConfigurationImpl rc = new ResourceConfigurationImpl();
                rc.setResourceType(ResourceType.DMN);
                DMNResource dmnResource = new DMNResource(definitions, (ResourceWithConfiguration)new ResourceWithConfigurationImpl(r, (ResourceConfiguration)rc, b -> {}, a -> {}));
                dmnResources.add(dmnResource);
            }
            DMNAssemblerService.enrichDMNResourcesWithImportsDependencies(dmnResources, Collections.emptyList());
            List<DMNResource> sortedDmnResources = DMNResourceDependenciesSorter.sort(dmnResources);
            ArrayList<DMNModel> dmnModels = new ArrayList<DMNModel>();
            for (DMNResource dmnRes : sortedDmnResources) {
                DMNModel dmnModel = this.dmnCompiler.compile(dmnRes.getDefinitions(), dmnRes.getResAndConfig().getResource(), dmnModels);
                dmnModels.add(dmnModel);
            }
            return Either.ofRight((Object)new DMNRuntimeImpl(new DMNRuntimeKBStatic(dmnModels, this.ctx.dmnProfiles)));
        }
    }

    private static class DMNRuntimeBuilderCtx {
        public final DMNCompilerConfigurationImpl cc;
        public final List<DMNProfile> dmnProfiles = new ArrayList<DMNProfile>();

        public DMNRuntimeBuilderCtx() {
            this.cc = new DMNCompilerConfigurationImpl();
        }
    }
}

