/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.validation.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramValidator;
import org.kie.workbench.common.stunner.core.validation.ModelValidator;
import org.kie.workbench.common.stunner.core.validation.impl.ElementViolationImpl;
import org.kie.workbench.common.stunner.core.validation.impl.GraphValidatorImpl;

public abstract class AbstractDiagramValidator
implements DiagramValidator<Diagram, RuleViolation> {
    private final GraphValidatorImpl graphValidator;
    private final ModelValidator modelValidator;

    protected AbstractDiagramValidator(DefinitionManager definitionManager, RuleManager ruleManager, TreeWalkTraverseProcessor treeWalkTraverseProcessor, ModelValidator modelValidator) {
        this.graphValidator = new GraphValidatorImpl(definitionManager, ruleManager, treeWalkTraverseProcessor);
        this.modelValidator = modelValidator;
    }

    public void validate(Diagram diagram, Consumer<Collection<DiagramElementViolation<RuleViolation>>> resultConsumer) {
        Graph graph = diagram.getGraph();
        LinkedList violations = new LinkedList();
        this.graphValidator.validate(graph, Optional.empty(), Optional.of((g, v) -> this.consumeBeanAndViolations(() -> violations).accept((Element)g, (Collection<RuleViolation>)v)), Optional.of((n, v) -> this.consumeBeanAndViolations(() -> violations).accept((Element)n, (Collection<RuleViolation>)v)), Optional.of((e, v) -> this.consumeBeanAndViolations(() -> violations).accept((Element)e, (Collection<RuleViolation>)v)), vs -> resultConsumer.accept(violations));
    }

    private BiConsumer<Element, Collection<RuleViolation>> consumeBeanAndViolations(Supplier<List<DiagramElementViolation<RuleViolation>>> violations) {
        return (element, ruleViolations) -> {
            if (Optional.ofNullable(element.getContent()).isPresent()) {
                this.modelValidator.validate(element, arg_0 -> AbstractDiagramValidator.lambda$null$7(ruleViolations, (Supplier)violations, element, arg_0));
            } else if (Objects.nonNull(ruleViolations) && !ruleViolations.isEmpty()) {
                ((List)violations.get()).add(new ElementViolationImpl.Builder().setUuid(element.getUUID()).setGraphViolations((Collection<RuleViolation>)ruleViolations).build());
            }
        };
    }

    private static /* synthetic */ void lambda$null$7(Collection ruleViolations, Supplier violations, Element element, Collection modelViolations) {
        if (Objects.nonNull(ruleViolations) && !ruleViolations.isEmpty() || Objects.nonNull(modelViolations) && !modelViolations.isEmpty()) {
            ((List)violations.get()).add(new ElementViolationImpl.Builder().setUuid(element.getUUID()).setGraphViolations(ruleViolations).setModelViolations(modelViolations).build());
        }
    }
}

