/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.validation.impl;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.validation.ModelBeanViolation;
import org.kie.workbench.common.stunner.core.validation.ModelValidator;
import org.kie.workbench.common.stunner.core.validation.impl.ModelBeanViolationImpl;

public abstract class AbstractModelBeanValidator
implements ModelValidator {
    private static Logger LOGGER = Logger.getLogger(AbstractModelBeanValidator.class.getName());

    protected abstract Validator getBeanValidator();

    public void validate(Element element, Consumer<Collection<ModelBeanViolation>> callback) {
        LOGGER.log(Level.INFO, "Performing model bean validation.");
        this.getBean(element).ifPresent(bean -> callback.accept(this.getBeanValidator().validate(bean, new Class[0]).stream().map(violation -> this.buildViolation((ConstraintViolation<?>)violation, element)).collect(Collectors.toSet())));
        LOGGER.log(Level.INFO, "Model bean validation completed.");
    }

    private ModelBeanViolation buildViolation(ConstraintViolation<?> rootViolation, Element element) {
        LOGGER.log(Level.INFO, "Bean constraint violation found with message [" + rootViolation.getMessage() + "]");
        return ModelBeanViolationImpl.Builder.build(rootViolation, element.getUUID());
    }

    private Optional<Object> getBean(Element element) {
        return Optional.ofNullable(element.getContent()).filter(content -> !(content instanceof DefinitionSet) && content instanceof Definition).map(content -> (Definition)content).map(Definition::getDefinition);
    }
}

