/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file;

import java.io.IOException;
import java.nio.file.Paths;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

public class FileSystemMetadata {
    private String scheme;
    private final String uri;
    private boolean isAFileSystemID;
    private String id;

    public FileSystemMetadata(FileSystem fs) {
        if (fs.getRootDirectories().iterator().hasNext()) {
            Path root = fs.getRootDirectories().iterator().next();
            FileSystem realFS = root.getFileSystem();
            this.isAFileSystemID = fs instanceof FileSystemId;
            this.id = this.isAFileSystemID ? ((FileSystemId)((Object)realFS)).id() : fs.toString();
            this.scheme = root.toUri().getScheme();
        }
        this.uri = fs.toString();
    }

    public boolean isAFileSystemID() {
        return this.isAFileSystemID;
    }

    public String getId() {
        return this.id;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemMetadata that = (FileSystemMetadata)o;
        if (this.isAFileSystemID != that.isAFileSystemID) {
            return false;
        }
        if (this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        int result = this.scheme != null ? this.scheme.hashCode() : 0;
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        result = 31 * result + (this.isAFileSystemID ? 1 : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public void closeFS() throws IOException {
        java.nio.file.Path path = Paths.get(this.uri, new String[0]);
        java.nio.file.FileSystem fileSystem = path.getFileSystem();
        fileSystem.close();
    }
}

