/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import org.drools.scenariosimulation.api.model.AbstractScesimData;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.ScesimDataWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;

public abstract class AbstractScesimModel<T extends AbstractScesimData> {
    protected final ScesimModelDescriptor scesimModelDescriptor = new ScesimModelDescriptor();
    protected final List<T> scesimData = new LinkedList<T>();

    public abstract AbstractScesimModel<T> cloneModel();

    public abstract T addData(int var1);

    public List<T> getUnmodifiableData() {
        return Collections.unmodifiableList(this.scesimData);
    }

    public void removeDataByIndex(int index) {
        this.scesimData.remove(index);
    }

    public void removeData(T toRemove) {
        this.scesimData.remove(toRemove);
    }

    public T getDataByIndex(int index) {
        return (T)((AbstractScesimData)this.scesimData.get(index));
    }

    public T addData() {
        return this.addData(this.scesimData.size());
    }

    public void replaceData(int index, T newScesimData) {
        this.scesimData.set(index, newScesimData);
    }

    public T cloneData(int sourceIndex, int targetIndex) {
        if (sourceIndex < 0 || sourceIndex >= this.scesimData.size()) {
            throw new IndexOutOfBoundsException("SourceIndex out of range " + sourceIndex);
        }
        if (targetIndex < 0 || targetIndex > this.scesimData.size()) {
            throw new IndexOutOfBoundsException("TargetIndex out of range " + targetIndex);
        }
        T scesimDataByIndex = this.getDataByIndex(sourceIndex);
        AbstractScesimData clonedScesimData = ((AbstractScesimData)scesimDataByIndex).cloneInstance();
        this.scesimData.add(targetIndex, clonedScesimData);
        return (T)clonedScesimData;
    }

    public void clear() {
        this.scesimModelDescriptor.clear();
        this.clearDatas();
    }

    public void clearDatas() {
        this.scesimData.clear();
    }

    public void resetErrors() {
        this.scesimData.forEach(AbstractScesimData::resetErrors);
    }

    public ScesimModelDescriptor getScesimModelDescriptor() {
        return this.scesimModelDescriptor;
    }

    public void removeFactMappingByIndex(int index) {
        this.clearDatas(this.scesimModelDescriptor.getFactMappingByIndex(index));
        this.scesimModelDescriptor.removeFactMappingByIndex(index);
    }

    public void removeFactMapping(FactMapping toRemove) {
        this.clearDatas(toRemove);
        this.scesimModelDescriptor.removeFactMapping(toRemove);
    }

    protected void clearDatas(FactMapping toRemove) {
        this.scesimData.forEach(e -> e.removeFactMappingValueByIdentifiers(toRemove.getFactIdentifier(), toRemove.getExpressionIdentifier()));
    }

    protected <Z extends ScesimDataWithIndex<T>> List<Z> toScesimDataWithIndex(BiFunction<Integer, T, Z> producer) {
        ArrayList<Z> toReturn = new ArrayList<Z>();
        List<T> data = this.getUnmodifiableData();
        for (int index = 0; index < data.size(); ++index) {
            toReturn.add(producer.apply(index + 1, (Integer)data.get(index)));
        }
        return toReturn;
    }
}

