/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties;

import java.util.Objects;
import java.util.Optional;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.AssociationDeclaration;

class AssociationParser {
    AssociationParser() {
    }

    public static AssociationDeclaration parse(String encoded) {
        if (Objects.nonNull(encoded)) {
            for (AssociationDeclaration.Direction direction : AssociationDeclaration.Direction.values()) {
                if (!encoded.startsWith(direction.prefix())) continue;
                String rest = encoded.substring(direction.prefix().length());
                return AssociationParser.parseAssociation(direction, rest);
            }
        }
        throw new IllegalArgumentException("Cannot parse " + encoded);
    }

    private static AssociationDeclaration parseAssociation(AssociationDeclaration.Direction direction, String rest) {
        AssociationDeclaration.Type type = Optional.ofNullable(rest).filter(s -> s.contains(AssociationDeclaration.Type.SourceTarget.op())).map(s -> AssociationDeclaration.Type.SourceTarget).orElseGet(() -> Optional.ofNullable(rest).filter(s -> s.contains(AssociationDeclaration.Type.FromTo.op())).map(s -> AssociationDeclaration.Type.FromTo).orElseThrow(() -> new IllegalArgumentException("Cannot parse " + rest)));
        String[] association = rest.split(type.op());
        String param1 = association.length > 0 ? association[0] : "";
        String param2 = association.length > 1 ? association[1] : "";
        return AssociationDeclaration.Type.SourceTarget.equals((Object)type) ? new AssociationDeclaration(direction, type, param1, param2) : new AssociationDeclaration(direction, type, param2, param1);
    }
}

