/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.List;
import java.util.Optional;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.AssociationDirection;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.BasePropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.EdgePropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.util.PropertyReaderUtils;
import org.kie.workbench.common.stunner.bpmn.definition.DirectionalAssociation;
import org.kie.workbench.common.stunner.bpmn.definition.NonDirectionalAssociation;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;

public class AssociationPropertyReader
extends BasePropertyReader
implements EdgePropertyReader {
    private final DefinitionResolver definitionResolver;
    private final Association association;

    public AssociationPropertyReader(Association association, BPMNDiagram diagram, DefinitionResolver definitionResolver) {
        super((BaseElement)association, diagram, definitionResolver.getShape(association.getId()), definitionResolver.getResolutionFactor());
        this.association = association;
        this.definitionResolver = definitionResolver;
    }

    @Override
    public String getSourceId() {
        return this.association.getSourceRef().getId();
    }

    @Override
    public String getTargetId() {
        return this.association.getTargetRef().getId();
    }

    public Class<? extends org.kie.workbench.common.stunner.bpmn.definition.Association> getAssociationByDirection() {
        return Optional.ofNullable(this.association.getAssociationDirection()).filter(d -> !AssociationDirection.NONE.equals(d)).map(d -> DirectionalAssociation.class).orElse(NonDirectionalAssociation.class);
    }

    @Override
    public Connection getSourceConnection() {
        Point2D sourcePosition = PropertyReaderUtils.getSourcePosition(this.definitionResolver, this.element.getId(), this.getSourceId());
        return MagnetConnection.Builder.at((double)sourcePosition.getX(), (double)sourcePosition.getY()).setAuto(PropertyReaderUtils.isAutoConnectionSource(this.element));
    }

    @Override
    public Connection getTargetConnection() {
        Point2D targetPosition = PropertyReaderUtils.getTargetPosition(this.definitionResolver, this.element.getId(), this.getTargetId());
        return MagnetConnection.Builder.at((double)targetPosition.getX(), (double)targetPosition.getY()).setAuto(PropertyReaderUtils.isAutoConnectionTarget(this.element));
    }

    @Override
    public List<Point2D> getControlPoints() {
        return PropertyReaderUtils.getControlPoints(this.definitionResolver, this.element.getId());
    }

    @Override
    public DefinitionResolver getDefinitionResolver() {
        return this.definitionResolver;
    }
}

