/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.util;

import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.ext.metadata.model.schema.MetaType;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.base.SegmentedPath;
import org.uberfire.java.nio.file.Path;

public class KObjectUtil {
    private static final MetaType META_TYPE = new MetaType(){

        public String getName() {
            return Path.class.getName();
        }
    };

    private KObjectUtil() {
    }

    public static KObjectKey toKObjectKey(final Path path, final String classifier) {
        return new KObjectKey(){

            public String getId() {
                return KObjectUtil.sha1(this.getType().getName() + "|" + classifier + "|" + this.getKey());
            }

            public MetaType getType() {
                return META_TYPE;
            }

            public String getClusterId() {
                String fsId = ((FileSystemId)path.getFileSystem()).id();
                String segmentId = ((SegmentedPath)path).getSegmentId();
                return fsId + "/" + segmentId;
            }

            public String getSegmentId() {
                return ((SegmentedPath)path).getSegmentId();
            }

            public String getKey() {
                return path.toUri().toString();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("KObject{, key='" + this.getKey() + '\'' + ", id='" + this.getId() + '\'' + ", type=" + this.getType() + ", clusterId='" + this.getClusterId() + '\'' + ", segmentId='" + this.getSegmentId() + '\'');
                sb.append('}');
                return sb.toString();
            }
        };
    }

    public static KObject toKObject(final Path path, final String classifier, final Set<KProperty<?>> indexElements) {
        return new KObject(){

            public String getId() {
                return KObjectUtil.sha1(this.getType().getName() + "|" + classifier + "|" + this.getKey());
            }

            public MetaType getType() {
                return META_TYPE;
            }

            public String getClusterId() {
                String fsId = ((FileSystemId)path.getFileSystem()).id();
                String segmentId = ((SegmentedPath)path).getSegmentId();
                return fsId + "/" + segmentId;
            }

            public String getSegmentId() {
                return ((SegmentedPath)path).getSegmentId();
            }

            public String getKey() {
                return path.toUri().toString();
            }

            public Iterable<KProperty<?>> getProperties() {
                return indexElements;
            }

            public boolean fullText() {
                return false;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("KObject{, key='" + this.getKey() + '\'' + ", id='" + this.getId() + '\'' + ", type=" + this.getType() + ", clusterId='" + this.getClusterId() + '\'' + ", segmentId='" + this.getSegmentId() + '\'');
                for (KProperty<?> xproperty : this.getProperties()) {
                    sb.append(", " + xproperty.getName() + "='" + xproperty.getValue() + '\'');
                }
                sb.append('}');
                return sb.toString();
            }
        };
    }

    private static String sha1(String input) {
        if (input == null || input.trim().length() == 0) {
            return "--";
        }
        return Base64.encodeBase64String((byte[])DigestUtils.sha1((String)input));
    }
}

