/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step02;

import java.util.Arrays;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.enterprise.inject.Default;
import org.kie.workbench.common.stunner.core.graph.processing.layout.ReorderedGraph;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Vertex;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.GraphLayer;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.GraphLayerImpl;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.LayeredGraph;
import org.kie.workbench.common.stunner.core.graph.processing.layout.sugiyama.step02.VertexLayerer;

@Default
public final class LongestPathVertexLayerer
implements VertexLayerer {
    private Vertex[] vertices;
    private final HashMap<String, Integer> vertexHeight = new HashMap();
    private LayeredGraph graph;

    public void createLayers(ReorderedGraph graph) {
        this.graph = (LayeredGraph)graph;
        this.vertices = new Vertex[this.graph.getVertices().size()];
        for (int i = 0; i < this.graph.getVertices().size(); ++i) {
            String v = this.graph.getVertices().get(i);
            this.vertices[i] = new Vertex(v);
            this.vertexHeight.put(v, -1);
        }
        for (Vertex vertex : this.vertices) {
            this.visit(vertex);
        }
    }

    private int visit(Vertex vertex) {
        String[] verticesFromHere;
        int height = this.vertexHeight.getOrDefault(vertex.getId(), 0);
        if (height >= 0) {
            return height;
        }
        int maxHeight = 1;
        for (String nextVertex : verticesFromHere = this.graph.getVerticesFrom(vertex.getId())) {
            if (Objects.equals(nextVertex, vertex.getId())) continue;
            Vertex next = Arrays.stream(this.vertices).filter(f -> Objects.equals(f.getId(), nextVertex)).findFirst().orElseThrow(() -> new NoSuchElementException("Can not found the vertex pointed in other side of the OrientedEdge."));
            int targetHeight = this.visit(next);
            maxHeight = Math.max(maxHeight, targetHeight + 1);
        }
        this.addToLayer(vertex, maxHeight);
        return maxHeight;
    }

    private void addToLayer(Vertex vertex, int height) {
        for (int i = this.graph.getLayers().size(); i < height; ++i) {
            this.graph.getLayers().add(0, new GraphLayerImpl());
        }
        int level = this.graph.getLayers().size() - height;
        GraphLayer layer = this.graph.getLayers().get(level);
        layer.setLevel(height);
        layer.addVertex(vertex);
        this.vertexHeight.put(vertex.getId(), height);
    }
}

