/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.transfer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.dashbuilder.dataset.DataSetDefRegistryCDI;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.events.DataSetDefRegisteredEvent;
import org.dashbuilder.navigation.event.NavTreeChangedEvent;
import org.dashbuilder.navigation.storage.NavTreeStorage;
import org.dashbuilder.transfer.DataTransferServices;
import org.jboss.errai.bus.server.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.plugin.event.PluginAdded;
import org.uberfire.ext.plugin.model.Plugin;
import org.uberfire.ext.plugin.type.TypeConverterUtil;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.SpacesAPI;

@ApplicationScoped
@Service
public class DataTransferServicesImpl
implements DataTransferServices {
    public static final String VERSION = "1.0.0";
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTransferServicesImpl.class);
    private IOService ioService;
    private FileSystem datasetsFS;
    private FileSystem perspectivesFS;
    private FileSystem navigationFS;
    private FileSystem systemFS;
    private DataSetDefRegistryCDI dataSetDefRegistryCDI;
    private SessionInfo sessionInfo;
    private Event<DataSetDefRegisteredEvent> dataSetDefRegisteredEvent;
    private Event<PluginAdded> pluginAddedEvent;
    private Event<NavTreeChangedEvent> navTreeChangedEvent;
    private NavTreeStorage navTreeStorage;
    private byte[] buffer = new byte[1024];

    public DataTransferServicesImpl() {
    }

    @Inject
    public DataTransferServicesImpl(@Named(value="ioStrategy") IOService ioService, @Named(value="datasetsFS") FileSystem datasetsFS, @Named(value="perspectivesFS") FileSystem perspectivesFS, @Named(value="navigationFS") FileSystem navigationFS, @Named(value="systemFS") FileSystem systemFS, DataSetDefRegistryCDI dataSetDefRegistryCDI, SessionInfo sessionInfo, Event<DataSetDefRegisteredEvent> dataSetDefRegisteredEvent, Event<PluginAdded> pluginAddedEvent, Event<NavTreeChangedEvent> navTreeChangedEvent, NavTreeStorage navTreeStorage) {
        this.ioService = ioService;
        this.datasetsFS = datasetsFS;
        this.perspectivesFS = perspectivesFS;
        this.navigationFS = navigationFS;
        this.systemFS = systemFS;
        this.dataSetDefRegistryCDI = dataSetDefRegistryCDI;
        this.sessionInfo = sessionInfo;
        this.dataSetDefRegisteredEvent = dataSetDefRegisteredEvent;
        this.pluginAddedEvent = pluginAddedEvent;
        this.navTreeChangedEvent = navTreeChangedEvent;
        this.navTreeStorage = navTreeStorage;
    }

    public String doExport() throws java.io.IOException {
        String zipLocation = System.getProperty("java.io.tmpdir") + File.separator + "dashbuilder-data-transfer" + File.separator + "export.zip";
        new File(zipLocation).getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(zipLocation);
        ZipOutputStream zos = new ZipOutputStream(fos);
        this.zipFileSystem(this.datasetsFS, zos);
        this.zipFileSystem(this.perspectivesFS, zos);
        this.zipFileSystem(this.navigationFS, zos);
        this.zipFile(this.createVersionFile(), "VERSION", zos);
        zos.close();
        fos.close();
        this.moveZipToFileSystem(zipLocation, this.systemFS);
        return SpacesAPI.Scheme.GIT + "://" + this.systemFS.getName() + File.separator + "dashbuilder-data-transfer" + File.separator + "export.zip";
    }

    public List<String> doImport() throws Exception {
        final ArrayList<String> imported = new ArrayList<String>();
        Path root = Paths.get((URI)URI.create(SpacesAPI.Scheme.GIT + "://" + this.systemFS.getName() + File.separator));
        final String expectedPath = File.separator + "dashbuilder-data-transfer" + File.separator + "import.zip";
        Files.walkFileTree((Path)root, (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                if (!path.toString().equalsIgnoreCase(expectedPath)) {
                    return FileVisitResult.CONTINUE;
                }
                try {
                    imported.addAll(DataTransferServicesImpl.this.importFiles(path));
                    return FileVisitResult.TERMINATE;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return FileVisitResult.TERMINATE;
                }
            }
        });
        this.ioService.deleteIfExists(root.resolve(expectedPath), new DeleteOption[0]);
        return imported;
    }

    private List<String> importFiles(Path path) throws Exception {
        String tempPath = System.getProperty("java.io.tmpdir") + File.separator + "dashbuilder-data-transfer" + File.separator;
        ArrayList<String> imported = new ArrayList<String>();
        File destDir = new File(tempPath);
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(path.toFile()));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File newFile = this.unzipFile(destDir, zipEntry, zis);
                zipEntry = zis.getNextEntry();
                FileSystem fileSystem = this.getImportFileSystem(newFile, tempPath);
                if (fileSystem == null) continue;
                URI uri = URI.create(SpacesAPI.Scheme.GIT + "://" + fileSystem.getName());
                String newFilePath = newFile.toPath().toString().replace(new StringBuilder(tempPath).append(fileSystem.getName()), "");
                this.ioService.write(Paths.get((URI)uri).resolve(newFilePath), java.nio.file.Files.readAllBytes(newFile.toPath()), new OpenOption[0]);
                imported.add(fileSystem.getName() + newFilePath);
                this.fireEvent(newFile, tempPath, uri, newFilePath);
            }
        }
        FileUtils.deleteDirectory((File)destDir);
        return imported;
    }

    private void fireEvent(File newFile, String tempPath, URI uri, String newFilePath) {
        String filePath = newFile.toURI().toString();
        if (filePath.contains(tempPath + this.datasetsFS.getName()) && newFilePath.endsWith(".dset")) {
            this.fireDatasetEvent(uri, newFilePath);
        } else if (filePath.contains(tempPath + this.perspectivesFS.getName()) && newFilePath.endsWith(".plugin")) {
            this.firePerspectiveEvent(newFile, uri, newFilePath);
        } else if (filePath.contains(tempPath + this.navigationFS.getName()) && newFilePath.endsWith("navtree.json")) {
            this.fireNavigationEvent();
        }
    }

    private void fireDatasetEvent(URI uri, String newFilePath) {
        try {
            String json = this.ioService.readAllString(Paths.get((URI)uri).resolve(newFilePath));
            DataSetDef newDef = this.dataSetDefRegistryCDI.getDataSetDefJsonMarshaller().fromJson(json);
            this.dataSetDefRegisteredEvent.fire((Object)new DataSetDefRegisteredEvent(newDef));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void firePerspectiveEvent(File newFile, URI uri, String newFilePath) {
        org.uberfire.backend.vfs.Path pluginPath = org.uberfire.backend.server.util.Paths.convert((Path)Paths.get((URI)uri).resolve(newFilePath));
        Plugin plugin = new Plugin(newFile.toPath().getParent().getFileName().toString(), TypeConverterUtil.fromPath((org.uberfire.backend.vfs.Path)pluginPath), pluginPath);
        this.pluginAddedEvent.fire((Object)new PluginAdded(plugin, this.sessionInfo));
    }

    private void fireNavigationEvent() {
        this.navTreeChangedEvent.fire((Object)new NavTreeChangedEvent(this.navTreeStorage.loadNavTree()));
    }

    private FileSystem getImportFileSystem(File file, String tempPath) {
        List<FileSystem> fileSystems = Arrays.asList(this.datasetsFS, this.perspectivesFS, this.navigationFS);
        String filePath = file.toURI().toString();
        return fileSystems.stream().filter(fs -> filePath.contains(tempPath + fs.getName())).findFirst().orElse(null);
    }

    private void moveZipToFileSystem(String zipLocation, FileSystem fileSystem) {
        String sourceLocation = SpacesAPI.Scheme.FILE + "://" + zipLocation;
        Path source = Paths.get((URI)URI.create(sourceLocation));
        Path target = Paths.get((URI)URI.create(SpacesAPI.Scheme.GIT + "://" + fileSystem.getName() + File.separator + "dashbuilder-data-transfer" + File.separator + "export.zip"));
        this.ioService.write(target, Files.readAllBytes((Path)source), new OpenOption[0]);
        Files.delete((Path)source, (DeleteOption[])new DeleteOption[0]);
    }

    private File unzipFile(File destinationDir, ZipEntry zipEntry, ZipInputStream zis) throws java.io.IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        if (!destFile.exists()) {
            destFile.getParentFile().mkdirs();
            if (!destFile.createNewFile()) {
                throw new IOException("could not create file " + destFile.getPath());
            }
        }
        try (FileOutputStream fos = new FileOutputStream(destFile);){
            int len;
            while ((len = zis.read(this.buffer)) > 0) {
                fos.write(this.buffer, 0, len);
            }
        }
        return destFile;
    }

    private void zipFileSystem(final FileSystem fs, final ZipOutputStream zos) {
        Path root = (Path)fs.getRootDirectories().iterator().next();
        Files.walkFileTree((Path)root, (FileVisitor)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                try {
                    String location = fs.getName() + path.toString();
                    DataTransferServicesImpl.this.zipFile(path.toFile(), location, zos);
                    return FileVisitResult.CONTINUE;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return FileVisitResult.TERMINATE;
                }
            }
        });
    }

    private void zipFile(File file, String path, ZipOutputStream zos) throws java.io.IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            int length;
            ZipEntry zipEntry = new ZipEntry(path);
            zos.putNextEntry(zipEntry);
            while ((length = fis.read(this.buffer)) >= 0) {
                zos.write(this.buffer, 0, length);
            }
            zos.closeEntry();
        }
    }

    private File createVersionFile() throws java.io.IOException {
        File version = File.createTempFile("temp", "version");
        try (BufferedWriter out = new BufferedWriter(new FileWriter(version));){
            out.write(VERSION);
        }
        return version;
    }
}

