/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes;

import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.elements.DefaultImportsElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.elements.ElementDefinition;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BaseConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.ConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes.RootProcessConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.DefinitionsPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagramImpl;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.DiagramSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.DefaultImport;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.Imports;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.ImportsValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.AdvancedData;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class RootProcessConverterTest {
    private DefinitionResolver definitionResolver;
    private Process process;
    private RootProcessConverter tested;

    @Before
    public void setUp() {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        this.process = Factories.bpmn2.createProcess();
        definitions.getRootElements().add(this.process);
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        definitions.getDiagrams().add(bpmnDiagram);
        ElementDefinition.getExtensionElements((BaseElement)this.process).add((Object)DefaultImportsElement.extensionOf((DefaultImport)new DefaultImport(this.getClass().getName())));
        this.definitionResolver = new DefinitionResolver(definitions, Collections.emptyList());
        NodeImpl node = new NodeImpl("");
        ViewImpl content = new ViewImpl((Object)new BPMNDiagramImpl(), Bounds.create());
        node.setContent((Object)content);
        FactoryManager factoryManager = (FactoryManager)Mockito.mock(FactoryManager.class);
        Mockito.when((Object)factoryManager.newElement(Matchers.anyString(), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(BPMNDiagramImpl.class)))).thenReturn((Object)node);
        TypedFactoryManager typedFactoryManager = new TypedFactoryManager(factoryManager);
        this.tested = new RootProcessConverter(typedFactoryManager, new PropertyReaderFactory(this.definitionResolver), this.definitionResolver, (BaseConverterFactory)new ConverterFactory(this.definitionResolver, typedFactoryManager));
    }

    @Test
    public void testCreateNode() {
        Assert.assertTrue((boolean)(((View)this.tested.createNode("id").getContent()).getDefinition() instanceof BPMNDiagramImpl));
    }

    @Test
    public void testCreateProcessData() {
        Assert.assertNotNull((Object)this.tested.createProcessData("id"));
    }

    @Test
    public void testCreateDiagramSet() {
        DiagramSet diagramSet = this.createDiagramSet();
        Assert.assertNotNull((Object)diagramSet);
    }

    @Test
    public void testImports() {
        DiagramSet diagramSet = this.createDiagramSet();
        Imports imports = diagramSet.getImports();
        Assert.assertNotNull((Object)imports);
        ImportsValue importsValue = imports.getValue();
        Assert.assertNotNull((Object)importsValue);
        List defaultImports = importsValue.getDefaultImports();
        Assert.assertNotNull((Object)defaultImports);
        Assert.assertFalse((boolean)defaultImports.isEmpty());
        DefaultImport defaultImport = (DefaultImport)defaultImports.get(0);
        Assert.assertNotNull((Object)defaultImport);
        Assert.assertEquals((Object)this.getClass().getName(), (Object)defaultImport.getClassName());
    }

    @Test
    public void createAdvancedData() {
        Assert.assertTrue((boolean)AdvancedData.class.isInstance(this.tested.createAdvancedData("id", "test\u00dfval")));
    }

    @Test
    public void convertAdvancedData() {
        this.tested.createAdvancedData("id", "test\u00dfval");
        Assert.assertTrue((boolean)this.tested.convertProcess().isSuccess());
    }

    private DiagramSet createDiagramSet() {
        return this.tested.createDiagramSet(this.process, new ProcessPropertyReader(this.process, this.definitionResolver.getDiagram(), this.definitionResolver.getShape(this.process.getId()), this.definitionResolver.getResolutionFactor()), new DefinitionsPropertyReader(this.definitionResolver.getDefinitions(), this.definitionResolver.getDiagram(), this.definitionResolver.getShape(this.process.getId()), this.definitionResolver.getResolutionFactor()));
    }
}

