/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.Point;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.DroolsPackage;
import org.jboss.drools.MetaDataType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.util.PropertyWriterUtils;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.util.PropertyReaderUtils;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.WSDLImport;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PropertyReaderUtilsTest {
    private static final String EDGE_ID = "EDGE_ID";
    private static final String SHAPE_ID = "SHAPE_ID";
    private static final float BOUNDS_X = 1.0f;
    private static final float BOUNDS_Y = 2.0f;
    private static final float BOUNDS_WIDTH = 2.0f;
    private static final float BOUNDS_HEIGHT = 4.0f;
    private static final float WAY_POINT_X = 1.0f;
    private static final float WAY_POINT_Y = 2.0f;
    @Mock
    private DefinitionResolver definitionResolver;
    @Mock
    private BPMNEdge edge;
    @Mock
    private BPMNShape shape;
    @Mock
    private Bounds bounds;
    @Mock
    private Point point;
    @Mock
    private BaseElement baseElement;

    @Before
    public void setUp() {
        Mockito.when((Object)Float.valueOf(this.bounds.getX())).thenReturn((Object)Float.valueOf(1.0f));
        Mockito.when((Object)Float.valueOf(this.bounds.getY())).thenReturn((Object)Float.valueOf(2.0f));
        Mockito.when((Object)Float.valueOf(this.bounds.getWidth())).thenReturn((Object)Float.valueOf(2.0f));
        Mockito.when((Object)Float.valueOf(this.bounds.getHeight())).thenReturn((Object)Float.valueOf(4.0f));
        Mockito.when((Object)Float.valueOf(this.point.getX())).thenReturn((Object)Float.valueOf(1.0f));
        Mockito.when((Object)Float.valueOf(this.point.getY())).thenReturn((Object)Float.valueOf(2.0f));
        Mockito.when((Object)this.definitionResolver.getResolutionFactor()).thenReturn((Object)1.0);
        Mockito.when((Object)this.definitionResolver.getEdge(EDGE_ID)).thenReturn((Object)this.edge);
        Mockito.when((Object)this.definitionResolver.getShape(SHAPE_ID)).thenReturn((Object)this.shape);
        Mockito.when((Object)this.shape.getBounds()).thenReturn((Object)this.bounds);
    }

    @Test
    public void testGetSourcePositionWithNoWaypoint() {
        Mockito.when((Object)this.edge.getWaypoint()).thenReturn(Collections.emptyList());
        Point2D point = PropertyReaderUtils.getSourcePosition((DefinitionResolver)this.definitionResolver, (String)EDGE_ID, (String)SHAPE_ID);
        this.assertPoint(2.0f, 2.0f, point);
    }

    @Test
    public void testGetSourcePositionWithWaypoint() {
        Mockito.when((Object)this.edge.getWaypoint()).thenReturn(Collections.singletonList(this.point));
        Point2D point = PropertyReaderUtils.getSourcePosition((DefinitionResolver)this.definitionResolver, (String)EDGE_ID, (String)SHAPE_ID);
        this.assertPoint(0.0f, 0.0f, point);
    }

    @Test
    public void testGetTargetPositionWithNoWaypoint() {
        Mockito.when((Object)this.edge.getWaypoint()).thenReturn(Collections.emptyList());
        Point2D point = PropertyReaderUtils.getTargetPosition((DefinitionResolver)this.definitionResolver, (String)EDGE_ID, (String)SHAPE_ID);
        this.assertPoint(0.0f, 2.0f, point);
    }

    @Test
    public void testGetTargetPositionWithWaypoint() {
        Mockito.when((Object)this.edge.getWaypoint()).thenReturn(Collections.singletonList(this.point));
        Point2D point = PropertyReaderUtils.getTargetPosition((DefinitionResolver)this.definitionResolver, (String)EDGE_ID, (String)SHAPE_ID);
        this.assertPoint(0.0f, 0.0f, point);
    }

    @Test
    public void testGetControlPointsWhenZeroPoints() {
        Mockito.when((Object)this.edge.getWaypoint()).thenReturn(Collections.emptyList());
        List result = PropertyReaderUtils.getControlPoints((DefinitionResolver)this.definitionResolver, (String)EDGE_ID);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testGetControlPointsWhenOnePoints() {
        List<Point> waypoints = this.mockPoints(1.0f, 2.0f, 1);
        Mockito.when((Object)this.edge.getWaypoint()).thenReturn(waypoints);
        List result = PropertyReaderUtils.getControlPoints((DefinitionResolver)this.definitionResolver, (String)EDGE_ID);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testGetControlPointsWhenTwoPoints() {
        List<Point> waypoints = this.mockPoints(1.0f, 2.0f, 2);
        Mockito.when((Object)this.edge.getWaypoint()).thenReturn(waypoints);
        List result = PropertyReaderUtils.getControlPoints((DefinitionResolver)this.definitionResolver, (String)EDGE_ID);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testGetControlPointsWhenThreePoints() {
        this.testGetControlPointsWhenMoreThanTwo(3);
    }

    @Test
    public void testGetControlPointsWhenNPoints() {
        this.testGetControlPointsWhenMoreThanTwo(10);
    }

    @Test
    public void testIsAutoConnectionSourceWithTrue() {
        this.testIsAutoConnectionSource("true", true);
    }

    @Test
    public void testIsAutoConnectionSourceWithFalse() {
        this.testIsAutoConnectionSource("false", false);
    }

    @Test
    public void testIsAutoConnectionSourceWithNull() {
        this.testIsAutoConnectionSource(null, false);
    }

    private void testIsAutoConnectionSource(String valueToSet, boolean expectedResult) {
        this.prepareExtensionElement(CustomElement.autoConnectionSource.name(), valueToSet);
        Assert.assertEquals((Object)expectedResult, (Object)PropertyReaderUtils.isAutoConnectionSource((BaseElement)this.baseElement));
    }

    @Test
    public void testIsAutoConnectionTargetWithTrue() {
        this.testIsAutoConnectionTarget("true", true);
    }

    @Test
    public void testIsAutoConnectionTargetWithFalse() {
        this.testIsAutoConnectionTarget("false", false);
    }

    @Test
    public void testIsAutoConnectionTargetWithNull() {
        this.testIsAutoConnectionTarget(null, false);
    }

    @Test
    public void testResolutionFactoryIsBeingAppliedOnControlPoints() {
        Mockito.when((Object)this.definitionResolver.getResolutionFactor()).thenReturn((Object)0.25);
        Mockito.when((Object)this.edge.getWaypoint()).thenReturn(Collections.emptyList());
        Point2D point = PropertyReaderUtils.getSourcePosition((DefinitionResolver)this.definitionResolver, (String)EDGE_ID, (String)SHAPE_ID);
        this.assertPoint(0.5f, 0.5f, point);
        Mockito.when((Object)this.edge.getWaypoint()).thenReturn(Collections.emptyList());
        point = PropertyReaderUtils.getTargetPosition((DefinitionResolver)this.definitionResolver, (String)EDGE_ID, (String)SHAPE_ID);
        this.assertPoint(0.0f, 0.5f, point);
        List<Point> waypoints = this.mockPoints(1.0f, 2.0f, 3);
        Mockito.when((Object)this.edge.getWaypoint()).thenReturn(waypoints);
        List result = PropertyReaderUtils.getControlPoints((DefinitionResolver)this.definitionResolver, (String)EDGE_ID);
        waypoints.remove(0);
        waypoints.remove(waypoints.size() - 1);
        Assert.assertEquals((long)waypoints.size(), (long)result.size());
        for (int i = 0; i < result.size(); ++i) {
            Assert.assertEquals((double)((double)waypoints.get(i).getX() * 0.25), (double)((Point2D)result.get(i)).getX(), (double)0.0);
            Assert.assertEquals((double)((double)waypoints.get(i).getY() * 0.25), (double)((Point2D)result.get(i)).getY(), (double)0.0);
        }
    }

    @Test
    public void toWSDLImports() {
        String LOCATION = "location";
        String NAMESPACE = "namespace";
        WSDLImport wsdlImport = new WSDLImport("location", "namespace");
        Import imp = PropertyWriterUtils.toImport((WSDLImport)wsdlImport);
        WSDLImport result = PropertyReaderUtils.toWSDLImports((Import)imp);
        Assert.assertEquals((Object)"location", (Object)result.getLocation());
        Assert.assertEquals((Object)"namespace", (Object)result.getNamespace());
    }

    private void testIsAutoConnectionTarget(String valueToSet, boolean expectedResult) {
        this.prepareExtensionElement(CustomElement.autoConnectionTarget.name(), valueToSet);
        Assert.assertEquals((Object)expectedResult, (Object)PropertyReaderUtils.isAutoConnectionTarget((BaseElement)this.baseElement));
    }

    private void prepareExtensionElement(String extensionElementName, String value) {
        ExtensionAttributeValue extensionAttributeValue = (ExtensionAttributeValue)Mockito.mock(ExtensionAttributeValue.class);
        FeatureMap extensionElements = (FeatureMap)Mockito.mock(FeatureMap.class);
        Mockito.when((Object)extensionAttributeValue.getValue()).thenReturn((Object)extensionElements);
        ArrayList<MetaDataType> metadataExtensions = new ArrayList<MetaDataType>();
        MetaDataType metaDataType = (MetaDataType)Mockito.mock(MetaDataType.class);
        Mockito.when((Object)metaDataType.getName()).thenReturn((Object)extensionElementName);
        Mockito.when((Object)metaDataType.getMetaValue()).thenReturn((Object)value);
        metadataExtensions.add(metaDataType);
        Mockito.when((Object)extensionElements.get((EStructuralFeature)DroolsPackage.Literals.DOCUMENT_ROOT__META_DATA, true)).thenReturn(metadataExtensions);
        ArrayList<ExtensionAttributeValue> extensionAttributes = new ArrayList<ExtensionAttributeValue>();
        extensionAttributes.add(extensionAttributeValue);
        Mockito.when((Object)this.baseElement.getExtensionValues()).thenReturn(extensionAttributes);
    }

    private void testGetControlPointsWhenMoreThanTwo(int size) {
        List<Point> waypoints = this.mockPoints(1.0f, 2.0f, size);
        Mockito.when((Object)this.edge.getWaypoint()).thenReturn(waypoints);
        List result = PropertyReaderUtils.getControlPoints((DefinitionResolver)this.definitionResolver, (String)EDGE_ID);
        waypoints.remove(0);
        waypoints.remove(waypoints.size() - 1);
        this.assertPoints(waypoints, result);
    }

    private void assertPoint(float x, float y, Point2D point2D) {
        Assert.assertNotNull((Object)point2D);
        Assert.assertEquals((double)x, (double)point2D.getX(), (double)0.0);
        Assert.assertEquals((double)y, (double)point2D.getY(), (double)0.0);
    }

    private void assertPoints(List<Point> originalPoints, List<Point2D> points) {
        Assert.assertEquals((long)originalPoints.size(), (long)points.size());
        for (int i = 0; i < points.size(); ++i) {
            Assert.assertEquals((double)originalPoints.get(i).getX(), (double)points.get(i).getX(), (double)0.0);
            Assert.assertEquals((double)originalPoints.get(i).getY(), (double)points.get(i).getY(), (double)0.0);
        }
    }

    private List<Point> mockPoints(float mockXStart, float mockYStart, int size) {
        ArrayList<Point> result = new ArrayList<Point>();
        for (int i = 0; i < size; ++i) {
            Point point = (Point)Mockito.mock(Point.class);
            Mockito.when((Object)Float.valueOf(point.getX())).thenReturn((Object)Float.valueOf(mockXStart + (float)i));
            Mockito.when((Object)Float.valueOf(point.getY())).thenReturn((Object)Float.valueOf(mockYStart + (float)i));
            result.add(point);
        }
        return result;
    }
}

