/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jpa;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.runtime.Cacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="JPADefinitions.wid", name="JPA", displayName="JPA", defaultHandler="mvel: new org.jbpm.process.workitem.jpa.JPAWorkItemHandler(\"persistenceUnit\", \"classloader\")", documentation="jpa-workitem/index.html", category="jpa-workitem", icon="JPA.png", parameters={@WidParameter(name="Type", runtimeType="java.lang.Object"), @WidParameter(name="Id", runtimeType="java.lang.Object"), @WidParameter(name="Entity", runtimeType="java.lang.Object"), @WidParameter(name="Action", required=true, runtimeType="java.lang.Object"), @WidParameter(name="Query", runtimeType="java.lang.Object"), @WidParameter(name="QueryParameters", runtimeType="java.lang.Object"), @WidParameter(name="QueryResults", runtimeType="java.lang.Object")}, results={@WidResult(name="Result", runtimeType="java.util.Map")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="jpa-workitem", version="7.37.0.Final")}, serviceInfo=@WidService(category="JPA", description="Perform JPA operation", keywords="jpa,query,named,entity", action=@WidAction(title="Perform a JPA operation"), authinfo=@WidAuth(required=true, params={"persistenceUnit"}, paramsdescription={"Persistence Unit name"}, referencesite="")))
public class JPAWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler
implements Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(JPAWorkItemHandler.class);
    public static final String P_RESULT = "Result";
    public static final String P_TYPE = "Type";
    public static final String P_ID = "Id";
    public static final String P_ENTITY = "Entity";
    public static final String P_ACTION = "Action";
    public static final String P_QUERY = "Query";
    public static final String P_QUERY_PARAMS = "QueryParameters";
    public static final String P_QUERY_RESULTS = "QueryResults";
    public static final String CREATE_ACTION = "CREATE";
    public static final String UPDATE_ACTION = "UPDATE";
    public static final String GET_ACTION = "GET";
    public static final String DELETE_ACTION = "DELETE";
    public static final String QUERY_ACTION = "QUERY";
    private EntityManagerFactory emf;
    private ClassLoader classloader;

    public JPAWorkItemHandler(String persistenceUnit) {
        this(persistenceUnit, JPAWorkItemHandler.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPAWorkItemHandler(String persistenceUnit, ClassLoader classloader) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classloader);
            this.emf = Persistence.createEntityManagerFactory((String)persistenceUnit);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        this.classloader = classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWorkItem(WorkItem wi, WorkItemManager wim) {
        Object actionParam = wi.getParameter(P_ACTION);
        Object entity = wi.getParameter(P_ENTITY);
        Object id = wi.getParameter(P_ID);
        Object type = wi.getParameter(P_TYPE);
        Object queryName = wi.getParameter(P_QUERY);
        Object queryParams = wi.getParameter(P_QUERY_PARAMS);
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<Object> queryResults = Collections.emptyList();
        if (entity == null && P_ACTION.equals(QUERY_ACTION)) {
            throw new IllegalArgumentException("An entity is required. Use the 'entity' parameter");
        }
        String action = String.valueOf(actionParam).trim().toUpperCase();
        logger.debug("Action {} on {}", (Object)action, entity);
        try (EntityManager em = this.emf.createEntityManager();){
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)wi);
            em.joinTransaction();
            switch (action) {
                case "DELETE": {
                    this.doDelete(em, entity, id);
                    break;
                }
                case "GET": {
                    if (id == null || type == null) {
                        throw new IllegalArgumentException("Id or type can't be null when getting an entity");
                    }
                    entity = this.doGet(em, type.toString(), Long.parseLong(id.toString()));
                    break;
                }
                case "UPDATE": {
                    this.doUpdate(em, entity);
                    break;
                }
                case "CREATE": {
                    em.persist(entity);
                    break;
                }
                case "QUERY": {
                    if (queryName == null) {
                        throw new IllegalArgumentException("You must provide a 'Query' parameter to run named queries.");
                    }
                    queryResults = this.doQuery(em, String.valueOf(queryName), queryParams);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Action " + action + " not recognized. Use 'delete', 'create', 'update', query, or 'get'");
                }
            }
            params.put(P_RESULT, entity);
            params.put(P_QUERY_RESULTS, queryResults);
            wim.completeWorkItem(wi.getId(), params);
        }
    }

    private List<Object> doQuery(EntityManager em, String queryName, Object queryParams) {
        logger.debug("About to run query {}", (Object)queryName);
        Query namedQuery = em.createQuery(queryName);
        if (queryParams == null) {
            logger.debug("No parameters were provided");
        } else {
            Map params = (Map)queryParams;
            logger.debug("Parameters {}", (Object)params);
            params.forEach((arg_0, arg_1) -> ((Query)namedQuery).setParameter(arg_0, arg_1));
        }
        return namedQuery.getResultList();
    }

    private Object doUpdate(EntityManager em, Object entity) {
        return em.merge(entity);
    }

    private Object doGet(EntityManager em, String clazz, Object id) {
        Class<?> type = this.loadClass(clazz);
        return em.find(type, id);
    }

    private void doDelete(EntityManager em, Object entity, Object id) {
        if (!em.contains(entity)) {
            entity = this.doGet(em, entity.getClass().getName(), id);
        }
        if (entity == null) {
            throw new IllegalArgumentException("Can't load the entity to remove. Provide an attached entity or the id to load it.");
        }
        em.remove(entity);
    }

    public void close() {
        this.emf.close();
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
        wim.abortWorkItem(wi.getId());
    }

    private Class<?> loadClass(String clazz) {
        try {
            return Class.forName(clazz, false, this.classloader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't load type " + clazz);
        }
    }
}

