/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.config.AnnotationConfiguration;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.OneOfDescriptor;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.impl.AnnotatedDescriptorImpl;

public final class Descriptor
extends AnnotatedDescriptorImpl
implements GenericDescriptor {
    private Integer typeId;
    private final List<Option> options;
    private final List<FieldDescriptor> fields;
    private final List<OneOfDescriptor> oneofs;
    private final List<Descriptor> nestedMessageTypes;
    private final List<EnumDescriptor> nestedEnumTypes;
    private final Map<Integer, FieldDescriptor> fieldsByNumber = new HashMap<Integer, FieldDescriptor>();
    private final Map<String, FieldDescriptor> fieldsByName = new HashMap<String, FieldDescriptor>();
    private FileDescriptor fileDescriptor;
    private Descriptor containingType;

    private Descriptor(Builder builder) {
        super(builder.name, builder.fullName, builder.documentation);
        this.options = Collections.unmodifiableList(builder.options);
        this.fields = Collections.unmodifiableList(builder.fields);
        this.addFields(builder.fields);
        this.oneofs = Collections.unmodifiableList(builder.oneofs);
        for (OneOfDescriptor oneOfDescriptor : this.oneofs) {
            this.addFields(oneOfDescriptor.getFields());
            oneOfDescriptor.setContainingMessage(this);
        }
        this.nestedMessageTypes = Collections.unmodifiableList(builder.nestedMessageTypes);
        this.nestedEnumTypes = Collections.unmodifiableList(builder.nestedEnumTypes);
        for (Descriptor descriptor : this.nestedMessageTypes) {
            descriptor.setContainingType(this);
        }
        for (EnumDescriptor enumDescriptor : this.nestedEnumTypes) {
            enumDescriptor.setContainingType(this);
        }
    }

    private void addFields(List<FieldDescriptor> fields) {
        for (FieldDescriptor fieldDescriptor : fields) {
            FieldDescriptor existing = this.fieldsByNumber.put(fieldDescriptor.getNumber(), fieldDescriptor);
            if (existing != null) {
                throw new IllegalStateException("Field number " + fieldDescriptor.getNumber() + " has already been used in \"" + this.fullName + "\" by field \"" + existing.getName() + "\".");
            }
            existing = this.fieldsByName.put(fieldDescriptor.getName(), fieldDescriptor);
            if (existing != null) {
                throw new IllegalStateException("Field \"" + fieldDescriptor.getName() + "\" is already defined in \"" + this.fullName + "\" with numbers " + existing.getNumber() + " and " + fieldDescriptor.getNumber() + ".");
            }
            fieldDescriptor.setContainingMessage(this);
        }
    }

    @Override
    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public Option getOption(String name) {
        for (Option o : this.options) {
            if (!o.getName().equals(name)) continue;
            return o;
        }
        return null;
    }

    public List<FieldDescriptor> getFields() {
        return this.fields;
    }

    public List<OneOfDescriptor> getOneOfs() {
        return this.oneofs;
    }

    public List<Descriptor> getNestedTypes() {
        return this.nestedMessageTypes;
    }

    public List<EnumDescriptor> getEnumTypes() {
        return this.nestedEnumTypes;
    }

    public FieldDescriptor findFieldByNumber(int number) {
        return this.fieldsByNumber.get(number);
    }

    public FieldDescriptor findFieldByName(String name) {
        return this.fieldsByName.get(name);
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
        for (FieldDescriptor fieldDescriptor : this.fields) {
            fieldDescriptor.setFileDescriptor(fileDescriptor);
        }
        for (Descriptor descriptor : this.nestedMessageTypes) {
            descriptor.setFileDescriptor(fileDescriptor);
        }
        for (EnumDescriptor enumDescriptor : this.nestedEnumTypes) {
            enumDescriptor.setFileDescriptor(fileDescriptor);
        }
        this.typeId = (Integer)this.getProcessedAnnotation("TypeId");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return this.fullName.equals(that.fullName);
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    @Override
    public Integer getTypeId() {
        return this.typeId;
    }

    @Override
    public Descriptor getContainingType() {
        return this.containingType;
    }

    private void setContainingType(Descriptor containingType) {
        this.containingType = containingType;
        for (Descriptor descriptor : this.nestedMessageTypes) {
            descriptor.setContainingType(this);
        }
        for (EnumDescriptor enumDescriptor : this.nestedEnumTypes) {
            enumDescriptor.setContainingType(this);
        }
    }

    @Override
    protected AnnotationConfiguration getAnnotationConfig(String annotationName) {
        AnnotationConfiguration annotationConfiguration = this.fileDescriptor.configuration.annotationsConfig().annotations().get(annotationName);
        if (annotationConfiguration == null) {
            return null;
        }
        for (AnnotationElement.AnnotationTarget t : annotationConfiguration.target()) {
            if (t != AnnotationElement.AnnotationTarget.MESSAGE) continue;
            return annotationConfiguration;
        }
        throw new DescriptorParserException("Annotation '" + annotationName + "' cannot be applied to message types.");
    }

    public String toString() {
        return "Descriptor{fullName=" + this.getFullName() + '}';
    }

    public static final class Builder {
        private String name;
        private String fullName;
        private List<Option> options;
        private List<FieldDescriptor> fields;
        private List<OneOfDescriptor> oneofs;
        private List<Descriptor> nestedMessageTypes;
        private List<EnumDescriptor> nestedEnumTypes;
        private String documentation;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withFullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public Builder withFields(List<FieldDescriptor> fields) {
            this.fields = fields;
            return this;
        }

        public Builder withOneOfs(List<OneOfDescriptor> oneofs) {
            this.oneofs = oneofs;
            return this;
        }

        public Builder withNestedTypes(List<Descriptor> nestedMessageTypes) {
            this.nestedMessageTypes = nestedMessageTypes;
            return this;
        }

        public Builder withEnumTypes(List<EnumDescriptor> nestedEnumTypes) {
            this.nestedEnumTypes = nestedEnumTypes;
            return this;
        }

        public Builder withDocumentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Descriptor build() {
            return new Descriptor(this);
        }
    }
}

