/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.ElementContainer;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations.AssociationConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.AssociationPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.definition.Association;
import org.kie.workbench.common.stunner.bpmn.definition.DirectionalAssociation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AssociationConverterTest {
    private static final String EDGE_ID = "EDGE_ID";
    private static final String SOURCE_NODE_ID = "SOURCE_NODE_ID";
    private static final String TARGET_NODE_ID = "TARGET_NODE_ID";
    private static final String ERROR_PATTERN = "BasePropertyWriter was not found for source node or target node at edge: %s, pSrc = %s, pTgt = %s";
    @Mock
    private PropertyWriterFactory propertyWriterFactory;
    @Mock
    private AssociationPropertyWriter associationPropertyWriter;
    @Mock
    private Edge<ViewConnector<Association>, Node> edge;
    @Mock
    private ViewConnector<Association> connector;
    @Mock
    private Node sourceNode;
    @Mock
    private Node targetNode;
    @Mock
    private BasePropertyWriter pSrc;
    @Mock
    private BasePropertyWriter pTgt;
    @Mock
    private ElementContainer process;
    private AssociationConverter converter;
    @Captor
    private ArgumentCaptor<org.eclipse.bpmn2.Association> argumentCaptor;

    @Before
    public void setUp() {
        Mockito.when((Object)this.propertyWriterFactory.of((org.eclipse.bpmn2.Association)Matchers.any(org.eclipse.bpmn2.Association.class))).thenReturn((Object)this.associationPropertyWriter);
        Mockito.when((Object)this.edge.getUUID()).thenReturn((Object)EDGE_ID);
        Mockito.when((Object)this.edge.getContent()).thenReturn(this.connector);
        Mockito.when((Object)this.edge.getSourceNode()).thenReturn((Object)this.sourceNode);
        Mockito.when((Object)this.edge.getTargetNode()).thenReturn((Object)this.targetNode);
        Mockito.when((Object)this.sourceNode.getUUID()).thenReturn((Object)SOURCE_NODE_ID);
        Mockito.when((Object)this.targetNode.getUUID()).thenReturn((Object)TARGET_NODE_ID);
        Mockito.when((Object)this.process.getChildElement(SOURCE_NODE_ID)).thenReturn((Object)this.pSrc);
        Mockito.when((Object)this.process.getChildElement(TARGET_NODE_ID)).thenReturn((Object)this.pTgt);
        this.converter = new AssociationConverter(this.propertyWriterFactory);
    }

    @Test
    public void testToFlowElementSuccess() {
        DirectionalAssociation association = new DirectionalAssociation();
        association.setGeneral(new BPMNGeneralSet("nameValue", "documentationValue"));
        Mockito.when((Object)this.connector.getDefinition()).thenReturn((Object)association);
        Result result = this.converter.toFlowElement(this.edge, this.process);
        Assert.assertTrue((boolean)result.isSuccess());
        ((PropertyWriterFactory)Mockito.verify((Object)this.propertyWriterFactory)).of((org.eclipse.bpmn2.Association)this.argumentCaptor.capture());
        Assert.assertEquals((Object)EDGE_ID, (Object)((org.eclipse.bpmn2.Association)this.argumentCaptor.getValue()).getId());
        ((AssociationPropertyWriter)Mockito.verify((Object)this.associationPropertyWriter)).setSource(this.pSrc);
        ((AssociationPropertyWriter)Mockito.verify((Object)this.associationPropertyWriter)).setTarget(this.pTgt);
        ((AssociationPropertyWriter)Mockito.verify((Object)this.associationPropertyWriter)).setConnection(this.connector);
        ((AssociationPropertyWriter)Mockito.verify((Object)this.associationPropertyWriter)).setDocumentation("documentationValue");
        ((AssociationPropertyWriter)Mockito.verify((Object)this.associationPropertyWriter)).setDirectionAssociation((Association)association);
    }

    @Test
    public void testToFlowElementWithSourceMissingFailure() {
        Mockito.when((Object)this.process.getChildElement(SOURCE_NODE_ID)).thenReturn(null);
        Result result = this.converter.toFlowElement(this.edge, this.process);
        this.verifyFailure(String.format(ERROR_PATTERN, EDGE_ID, null, this.pTgt), (Result<BasePropertyWriter>)result);
    }

    @Test
    public void testToFlowElementWithTargetMissingFailure() {
        Mockito.when((Object)this.process.getChildElement(TARGET_NODE_ID)).thenReturn(null);
        Result result = this.converter.toFlowElement(this.edge, this.process);
        this.verifyFailure(String.format(ERROR_PATTERN, EDGE_ID, this.pSrc, null), (Result<BasePropertyWriter>)result);
    }

    @Test
    public void testToFlowElementWithSourceAndTargetMissingFailure() {
        Mockito.when((Object)this.process.getChildElement(SOURCE_NODE_ID)).thenReturn(null);
        Mockito.when((Object)this.process.getChildElement(TARGET_NODE_ID)).thenReturn(null);
        Result result = this.converter.toFlowElement(this.edge, this.process);
        this.verifyFailure(String.format(ERROR_PATTERN, EDGE_ID, null, null), (Result<BasePropertyWriter>)result);
    }

    private void verifyFailure(String expectedError, Result<BasePropertyWriter> result) {
        Assert.assertTrue((boolean)result.isFailure());
        Assert.assertEquals((Object)expectedError, (Object)result.asFailure().reason());
    }
}

