/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.jbpm.server.context.generation.dynamic.impl.marshalling;

import java.util.Date;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.document.Document;
import org.jbpm.document.service.impl.DocumentImpl;
import org.jbpm.document.service.impl.util.DocumentDownloadLinkGenerator;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.AbstractFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.FieldValueMarshaller;
import org.kie.workbench.common.forms.jbpm.model.authoring.document.definition.DocumentFieldDefinition;
import org.kie.workbench.common.forms.jbpm.model.document.DocumentData;
import org.kie.workbench.common.forms.jbpm.model.document.DocumentStatus;
import org.kie.workbench.common.forms.jbpm.server.service.impl.documents.storage.UploadedDocumentStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class DocumentFieldValueMarshaller
extends AbstractFieldValueMarshaller<Document, DocumentData, DocumentFieldDefinition> {
    public static final String SERVER_TEMPLATE_ID = "serverTemplateId";
    private static final Logger logger = LoggerFactory.getLogger(DocumentFieldValueMarshaller.class);
    private UploadedDocumentStorage documentStorage;

    @Inject
    public DocumentFieldValueMarshaller(UploadedDocumentStorage documentStorage) {
        this.documentStorage = documentStorage;
    }

    public Class<DocumentFieldDefinition> getSupportedField() {
        return DocumentFieldDefinition.class;
    }

    public Supplier<FieldValueMarshaller<Document, DocumentData, DocumentFieldDefinition>> newInstanceSupplier() {
        return () -> new DocumentFieldValueMarshaller(this.documentStorage);
    }

    public DocumentData toFlatValue() {
        if (this.originalValue == null) {
            return null;
        }
        String templateId = (String)this.context.getAttributes().get(SERVER_TEMPLATE_ID);
        return DocumentFieldValueMarshaller.fromDocument((Document)this.originalValue, templateId);
    }

    static DocumentData fromDocument(Document document, String templateId) {
        String link = !StringUtils.isEmpty((CharSequence)templateId) && !StringUtils.isEmpty((CharSequence)document.getIdentifier()) ? DocumentDownloadLinkGenerator.generateDownloadLink((String)templateId, (String)document.getIdentifier()) : document.getLink();
        DocumentData data = new DocumentData(document.getIdentifier(), document.getName(), document.getSize(), link, document.getLastModified().getTime());
        data.setStatus(DocumentStatus.STORED);
        return data;
    }

    public Document toRawValue(DocumentData documentData) {
        if (documentData == null) {
            return null;
        }
        if (documentData.getStatus().equals((Object)DocumentStatus.STORED)) {
            return (Document)this.originalValue;
        }
        return DocumentFieldValueMarshaller.toDocument(documentData, this.documentStorage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Document toDocument(DocumentData documentData, UploadedDocumentStorage documentStorage) {
        DocumentImpl document = new DocumentImpl();
        document.setIdentifier(documentData.getContentId());
        document.setName(documentData.getFileName());
        document.setSize(documentData.getSize());
        document.setLastModified(new Date(documentData.getLastModified()));
        if (documentData.getStatus().equals((Object)DocumentStatus.NEW)) {
            try {
                byte[] content = documentStorage.getContent(documentData.getContentId());
                document.setContent(content);
            }
            catch (Exception ex) {
                logger.warn("Error getting content for document '{}' ({}): {}", new Object[]{document.getIdentifier(), document.getName(), ex});
            }
            finally {
                documentStorage.removeContent(documentData.getContentId());
            }
        } else {
            document.setLink(documentData.getLink());
        }
        return document;
    }
}

