/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.marshalling.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.util.StringUtils;
import org.jbpm.marshalling.impl.ProcessInstanceMarshaller;
import org.jbpm.process.core.Context;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.context.exclusive.ExclusiveGroupInstance;
import org.jbpm.process.instance.context.swimlane.SwimlaneContextInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.ForEachNodeInstance;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.jbpm.workflow.instance.node.JoinInstance;
import org.jbpm.workflow.instance.node.MilestoneNodeInstance;
import org.jbpm.workflow.instance.node.RuleSetNodeInstance;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.jbpm.workflow.instance.node.StateNodeInstance;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.jbpm.workflow.instance.node.TimerNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.definition.process.Process;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessInstance;

public abstract class AbstractProcessInstanceMarshaller
implements ProcessInstanceMarshaller {
    @Override
    public Object writeProcessInstance(MarshallerWriteContext context, ProcessInstance processInstance) throws IOException {
        WorkflowProcessInstanceImpl workFlow = (WorkflowProcessInstanceImpl)processInstance;
        context.writeLong(workFlow.getId());
        context.writeUTF(workFlow.getProcessId());
        context.writeInt(workFlow.getState());
        context.writeLong(workFlow.getNodeInstanceCounter());
        SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)workFlow.getContextInstance("SwimlaneScope");
        if (swimlaneContextInstance != null) {
            Map<String, String> swimlaneActors = swimlaneContextInstance.getSwimlaneActors();
            context.writeInt(swimlaneActors.size());
            for (Map.Entry<String, String> entry : swimlaneActors.entrySet()) {
                context.writeUTF(entry.getKey());
                context.writeUTF(entry.getValue());
            }
        } else {
            context.writeInt(0);
        }
        ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(workFlow.getNodeInstances());
        Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

            @Override
            public int compare(NodeInstance o1, NodeInstance o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
        for (NodeInstance nodeInstance : nodeInstances) {
            context.writeShort(18);
            this.writeNodeInstance(context, nodeInstance);
        }
        context.writeShort(1);
        List<ContextInstance> exclusiveGroupInstances = workFlow.getContextInstances("ExclusiveGroup");
        if (exclusiveGroupInstances == null) {
            context.writeInt(0);
        } else {
            context.writeInt(exclusiveGroupInstances.size());
            for (ContextInstance contextInstance : exclusiveGroupInstances) {
                ExclusiveGroupInstance exclusiveGroupInstance = (ExclusiveGroupInstance)contextInstance;
                Collection<NodeInstance> groupNodeInstances = exclusiveGroupInstance.getNodeInstances();
                context.writeInt(groupNodeInstances.size());
                for (NodeInstance nodeInstance : groupNodeInstances) {
                    context.writeLong(nodeInstance.getId());
                }
            }
        }
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)workFlow.getContextInstance("VariableScope");
        Map<String, Object> variables = variableScopeInstance.getVariables();
        ArrayList<String> keys = new ArrayList<String>(variables.keySet());
        Collection<Object> values = variables.values();
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        ArrayList<Object> notNullValues = new ArrayList<Object>();
        for (Object value : values) {
            if (value == null) continue;
            notNullValues.add(value);
        }
        context.writeInt(notNullValues.size());
        for (String key : keys) {
            Object object = variables.get(key);
            if (object == null) continue;
            context.writeUTF(key);
            int useNewMarshallingStrategyAlgorithm = -2;
            context.writeInt(useNewMarshallingStrategyAlgorithm);
            ObjectMarshallingStrategy strategy = context.getObjectMarshallingStrategyStore().getStrategyObject(object);
            context.writeUTF(strategy.getClass().getName());
            strategy.write((ObjectOutputStream)context, object);
        }
        return null;
    }

    @Override
    public Object writeNodeInstance(MarshallerWriteContext context, NodeInstance nodeInstance) throws IOException {
        context.writeLong(nodeInstance.getId());
        context.writeLong(nodeInstance.getNodeId());
        this.writeNodeInstanceContent(context, nodeInstance, context);
        return null;
    }

    protected void writeNodeInstanceContent(MarshallerWriteContext stream, NodeInstance nodeInstance, MarshallerWriteContext context) throws IOException {
        if (nodeInstance instanceof RuleSetNodeInstance) {
            stream.writeShort(20);
            List<Long> timerInstances = ((RuleSetNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id.longValue());
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof HumanTaskNodeInstance) {
            stream.writeShort(27);
            stream.writeLong(((HumanTaskNodeInstance)nodeInstance).getWorkItemId());
            List<Long> timerInstances = ((HumanTaskNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id.longValue());
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof WorkItemNodeInstance) {
            stream.writeShort(21);
            stream.writeLong(((WorkItemNodeInstance)nodeInstance).getWorkItemId());
            List<Long> timerInstances = ((WorkItemNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id.longValue());
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof SubProcessNodeInstance) {
            stream.writeShort(22);
            stream.writeLong(((SubProcessNodeInstance)nodeInstance).getProcessInstanceId());
            List<Long> timerInstances = ((SubProcessNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id.longValue());
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof MilestoneNodeInstance) {
            stream.writeShort(23);
            List<Long> timerInstances = ((MilestoneNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id.longValue());
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof EventNodeInstance) {
            stream.writeShort(32);
        } else if (nodeInstance instanceof TimerNodeInstance) {
            stream.writeShort(24);
            stream.writeLong(((TimerNodeInstance)nodeInstance).getTimerId());
        } else if (nodeInstance instanceof JoinInstance) {
            stream.writeShort(25);
            Map<Long, Integer> triggers = ((JoinInstance)nodeInstance).getTriggers();
            stream.writeInt(triggers.size());
            ArrayList<Long> keys = new ArrayList<Long>(triggers.keySet());
            Collections.sort(keys, new Comparator<Long>(){

                @Override
                public int compare(Long o1, Long o2) {
                    return o1.compareTo(o2);
                }
            });
            for (Long key : keys) {
                stream.writeLong(key.longValue());
                stream.writeInt(triggers.get(key).intValue());
            }
        } else if (nodeInstance instanceof StateNodeInstance) {
            stream.writeShort(30);
            List<Long> timerInstances = ((StateNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id.longValue());
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof CompositeContextNodeInstance) {
            if (nodeInstance instanceof DynamicNodeInstance) {
                stream.writeShort(31);
            } else {
                stream.writeShort(26);
            }
            CompositeContextNodeInstance compositeNodeInstance = (CompositeContextNodeInstance)nodeInstance;
            List<Long> timerInstances = ((CompositeContextNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (Long id : timerInstances) {
                    stream.writeLong(id.longValue());
                }
            } else {
                stream.writeInt(0);
            }
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)compositeNodeInstance.getContextInstance("VariableScope");
            if (variableScopeInstance == null) {
                stream.writeInt(0);
            } else {
                Map<String, Object> variables = variableScopeInstance.getVariables();
                ArrayList<String> keys = new ArrayList<String>(variables.keySet());
                Collections.sort(keys, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareTo(o2);
                    }
                });
                stream.writeInt(keys.size());
                Iterator<Object> iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    stream.writeUTF(key);
                    stream.writeObject(variables.get(key));
                }
            }
            ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(compositeNodeInstance.getNodeInstances());
            Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

                @Override
                public int compare(NodeInstance o1, NodeInstance o2) {
                    return (int)(o1.getId() - o2.getId());
                }
            });
            for (NodeInstance subNodeInstance : nodeInstances) {
                stream.writeShort(18);
                this.writeNodeInstance(context, subNodeInstance);
            }
            stream.writeShort(1);
            List<ContextInstance> exclusiveGroupInstances = compositeNodeInstance.getContextInstances("ExclusiveGroup");
            if (exclusiveGroupInstances == null) {
                stream.writeInt(0);
            } else {
                stream.writeInt(exclusiveGroupInstances.size());
                for (ContextInstance contextInstance : exclusiveGroupInstances) {
                    ExclusiveGroupInstance exclusiveGroupInstance = (ExclusiveGroupInstance)contextInstance;
                    Collection<NodeInstance> groupNodeInstances = exclusiveGroupInstance.getNodeInstances();
                    stream.writeInt(groupNodeInstances.size());
                    for (NodeInstance groupNodeInstance : groupNodeInstances) {
                        stream.writeLong(groupNodeInstance.getId());
                    }
                }
            }
        } else if (nodeInstance instanceof ForEachNodeInstance) {
            stream.writeShort(28);
            ForEachNodeInstance forEachNodeInstance = (ForEachNodeInstance)nodeInstance;
            ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(forEachNodeInstance.getNodeInstances());
            Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

                @Override
                public int compare(NodeInstance o1, NodeInstance o2) {
                    return (int)(o1.getId() - o2.getId());
                }
            });
            for (NodeInstance subNodeInstance : nodeInstances) {
                if (!(subNodeInstance instanceof CompositeContextNodeInstance)) continue;
                stream.writeShort(18);
                this.writeNodeInstance(context, subNodeInstance);
            }
            stream.writeShort(1);
        } else {
            throw new IllegalArgumentException("Unknown node instance type: " + nodeInstance);
        }
    }

    @Override
    public ProcessInstance readProcessInstance(MarshallerReaderContext context) throws IOException {
        InternalKnowledgeBase kBase = context.getKnowledgeBase();
        InternalWorkingMemory wm = context.getWorkingMemory();
        WorkflowProcessInstanceImpl processInstance = this.createProcessInstance();
        processInstance.setId(context.readLong());
        String processId = context.readUTF();
        processInstance.setProcessId(processId);
        Process process = kBase.getProcess(processId);
        if (kBase != null) {
            processInstance.setProcess(process);
        }
        processInstance.setState(context.readInt());
        long nodeInstanceCounter = context.readLong();
        processInstance.setKnowledgeRuntime(wm.getKnowledgeRuntime());
        int nbSwimlanes = context.readInt();
        if (nbSwimlanes > 0) {
            Context swimlaneContext = ((org.jbpm.process.core.Process)process).getDefaultContext("SwimlaneScope");
            SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)processInstance.getContextInstance(swimlaneContext);
            for (int i = 0; i < nbSwimlanes; ++i) {
                String name = context.readUTF();
                String value = context.readUTF();
                swimlaneContextInstance.setActorId(name, value);
            }
        }
        while (context.readShort() == 18) {
            this.readNodeInstance(context, processInstance, processInstance);
        }
        int exclusiveGroupInstances = context.readInt();
        for (int i = 0; i < exclusiveGroupInstances; ++i) {
            ExclusiveGroupInstance exclusiveGroupInstance = new ExclusiveGroupInstance();
            processInstance.addContextInstance("ExclusiveGroup", exclusiveGroupInstance);
            int nodeInstances = context.readInt();
            for (int j = 0; j < nodeInstances; ++j) {
                long nodeInstanceId = context.readLong();
                org.jbpm.workflow.instance.NodeInstance nodeInstance = processInstance.getNodeInstance(nodeInstanceId);
                if (nodeInstance == null) {
                    throw new IllegalArgumentException("Could not find node instance when deserializing exclusive group instance: " + nodeInstanceId);
                }
                exclusiveGroupInstance.addNodeInstance(nodeInstance);
            }
        }
        int nbVariables = context.readInt();
        if (nbVariables > 0) {
            Context variableScope = ((org.jbpm.process.core.Process)process).getDefaultContext("VariableScope");
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)processInstance.getContextInstance(variableScope);
            for (int i = 0; i < nbVariables; ++i) {
                String name = context.readUTF();
                try {
                    String strategyClassName;
                    ObjectMarshallingStrategy strategy = null;
                    int index = context.readInt();
                    if (index >= 0) {
                        strategy = context.getResolverStrategyFactory().getStrategy(index);
                    } else if (index == -2 && !StringUtils.isEmpty((CharSequence)(strategyClassName = context.readUTF())) && (strategy = context.getResolverStrategyFactory().getStrategyObject(strategyClassName)) == null) {
                        throw new IllegalStateException("No strategy of type " + strategyClassName + " available.");
                    }
                    Object value = null;
                    if (strategy != null) {
                        value = strategy.read((ObjectInputStream)context);
                    }
                    variableScopeInstance.internalSetVariable(name, value);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Could not reload variable " + name);
                }
            }
        }
        processInstance.internalSetNodeInstanceCounter(nodeInstanceCounter);
        if (wm != null) {
            processInstance.reconnect();
        }
        return processInstance;
    }

    protected abstract WorkflowProcessInstanceImpl createProcessInstance();

    @Override
    public NodeInstance readNodeInstance(MarshallerReaderContext context, NodeInstanceContainer nodeInstanceContainer, org.kie.api.runtime.process.WorkflowProcessInstance processInstance) throws IOException {
        long id = context.readLong();
        long nodeId = context.readLong();
        short nodeType = context.readShort();
        NodeInstanceImpl nodeInstance = this.readNodeInstanceContent(nodeType, context, processInstance);
        nodeInstance.setNodeId(nodeId);
        nodeInstance.setNodeInstanceContainer(nodeInstanceContainer);
        nodeInstance.setProcessInstance((WorkflowProcessInstance)processInstance);
        nodeInstance.setId(id);
        switch (nodeType) {
            case 26: 
            case 31: {
                int nbVariables = context.readInt();
                if (nbVariables > 0) {
                    Context variableScope = ((org.jbpm.process.core.Process)((org.jbpm.process.instance.ProcessInstance)processInstance).getProcess()).getDefaultContext("VariableScope");
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((CompositeContextNodeInstance)nodeInstance).getContextInstance(variableScope);
                    for (int i = 0; i < nbVariables; ++i) {
                        String name = context.readUTF();
                        try {
                            Object value = context.readObject();
                            variableScopeInstance.internalSetVariable(name, value);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Could not reload variable " + name);
                        }
                    }
                }
                while (context.readShort() == 18) {
                    this.readNodeInstance(context, (CompositeContextNodeInstance)nodeInstance, processInstance);
                }
                int exclusiveGroupInstances = context.readInt();
                for (int i = 0; i < exclusiveGroupInstances; ++i) {
                    ExclusiveGroupInstance exclusiveGroupInstance = new ExclusiveGroupInstance();
                    ((org.jbpm.process.instance.ProcessInstance)processInstance).addContextInstance("ExclusiveGroup", exclusiveGroupInstance);
                    int nodeInstances = context.readInt();
                    for (int j = 0; j < nodeInstances; ++j) {
                        long nodeInstanceId = context.readLong();
                        NodeInstance groupNodeInstance = processInstance.getNodeInstance(nodeInstanceId);
                        if (groupNodeInstance == null) {
                            throw new IllegalArgumentException("Could not find node instance when deserializing exclusive group instance: " + nodeInstanceId);
                        }
                        exclusiveGroupInstance.addNodeInstance(groupNodeInstance);
                    }
                }
                break;
            }
            case 28: {
                while (context.readShort() == 18) {
                    this.readNodeInstance(context, (ForEachNodeInstance)nodeInstance, processInstance);
                }
                break;
            }
        }
        return nodeInstance;
    }

    protected NodeInstanceImpl readNodeInstanceContent(int nodeType, MarshallerReaderContext context, org.kie.api.runtime.process.WorkflowProcessInstance processInstance) throws IOException {
        NodeInstanceImpl nodeInstance = null;
        switch (nodeType) {
            case 20: {
                nodeInstance = new RuleSetNodeInstance();
                int nbTimerInstances = context.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(context.readLong());
                }
                ((StateBasedNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 27: {
                nodeInstance = new HumanTaskNodeInstance();
                ((HumanTaskNodeInstance)nodeInstance).internalSetWorkItemId(context.readLong());
                int nbTimerInstances = context.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(context.readLong());
                }
                ((HumanTaskNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 21: {
                nodeInstance = new WorkItemNodeInstance();
                ((WorkItemNodeInstance)nodeInstance).internalSetWorkItemId(context.readLong());
                int nbTimerInstances = context.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(context.readLong());
                }
                ((WorkItemNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 22: {
                nodeInstance = new SubProcessNodeInstance();
                ((SubProcessNodeInstance)nodeInstance).internalSetProcessInstanceId(context.readLong());
                int nbTimerInstances = context.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(context.readLong());
                }
                ((SubProcessNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 23: {
                nodeInstance = new MilestoneNodeInstance();
                int nbTimerInstances = context.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(context.readLong());
                }
                ((MilestoneNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 24: {
                nodeInstance = new TimerNodeInstance();
                ((TimerNodeInstance)nodeInstance).internalSetTimerId(context.readLong());
                break;
            }
            case 32: {
                nodeInstance = new EventNodeInstance();
                break;
            }
            case 25: {
                nodeInstance = new JoinInstance();
                int number = context.readInt();
                if (number <= 0) break;
                HashMap<Long, Integer> triggers = new HashMap<Long, Integer>();
                for (int i = 0; i < number; ++i) {
                    long l = context.readLong();
                    int count = context.readInt();
                    triggers.put(l, count);
                }
                ((JoinInstance)nodeInstance).internalSetTriggers(triggers);
                break;
            }
            case 26: {
                nodeInstance = new CompositeContextNodeInstance();
                int nbTimerInstances = context.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(context.readLong());
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 28: {
                nodeInstance = new ForEachNodeInstance();
                break;
            }
            case 31: {
                nodeInstance = new DynamicNodeInstance();
                int nbTimerInstances = context.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(context.readLong());
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 30: {
                nodeInstance = new StateNodeInstance();
                int nbTimerInstances = context.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(context.readLong());
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node type: " + nodeType);
            }
        }
        return nodeInstance;
    }
}

