/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.ProcessEventSupport;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.time.TimeUtils;
import org.drools.core.time.TimerService;
import org.drools.core.time.impl.CommandServiceTimerJobFactoryManager;
import org.drools.core.time.impl.ThreadSafeTrackableTimeJobFactoryManager;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.serialization.protobuf.ProtobufMessages;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTransformer;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessInstanceFactory;
import org.jbpm.process.instance.ProcessInstanceFactoryRegistry;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.ProcessInstanceManagerFactory;
import org.jbpm.process.instance.event.SignalManager;
import org.jbpm.process.instance.event.SignalManagerFactory;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.utils.CompositeClassLoader;
import org.kie.soup.commons.cron.CronExpression;

public class ProcessRuntimeImpl
implements InternalProcessRuntime {
    private InternalKnowledgeRuntime kruntime;
    private ProcessInstanceManager processInstanceManager;
    private SignalManager signalManager;
    private TimerManager timerManager;
    private ProcessEventSupport processEventSupport;

    public ProcessRuntimeImpl(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
        TimerService timerService = kruntime.getTimerService();
        if (!(timerService.getTimerJobFactoryManager() instanceof CommandServiceTimerJobFactoryManager)) {
            timerService.setTimerJobFactoryManager((TimerJobFactoryManager)new ThreadSafeTrackableTimeJobFactoryManager());
        }
        ((CompositeClassLoader)this.getRootClassLoader()).addClassLoader(this.getClass().getClassLoader());
        this.initProcessInstanceManager();
        this.initSignalManager();
        this.timerManager = new TimerManager(kruntime, kruntime.getTimerService());
        this.processEventSupport = new ProcessEventSupport();
        if (this.isActive()) {
            this.initProcessEventListeners();
            this.initStartTimers();
        }
        this.initProcessActivationListener();
    }

    public void initStartTimers() {
        KieBase kbase = this.kruntime.getKieBase();
        Collection processes = kbase.getProcesses();
        for (Process process : processes) {
            RuleFlowProcess p = (RuleFlowProcess)process;
            List<StartNode> startNodes = p.getTimerStart();
            if (startNodes == null || startNodes.isEmpty()) continue;
            this.kruntime.queueWorkingMemoryAction((WorkingMemoryAction)new RegisterStartTimerAction(p.getId(), startNodes, this.timerManager));
        }
    }

    public ProcessRuntimeImpl(InternalWorkingMemory workingMemory) {
        TimerService timerService = workingMemory.getTimerService();
        if (!(timerService.getTimerJobFactoryManager() instanceof CommandServiceTimerJobFactoryManager)) {
            timerService.setTimerJobFactoryManager((TimerJobFactoryManager)new ThreadSafeTrackableTimeJobFactoryManager());
        }
        this.kruntime = workingMemory.getKnowledgeRuntime();
        this.initProcessInstanceManager();
        this.initSignalManager();
        this.timerManager = new TimerManager(this.kruntime, this.kruntime.getTimerService());
        this.processEventSupport = new ProcessEventSupport();
        if (this.isActive()) {
            this.initProcessEventListeners();
            this.initStartTimers();
        }
        this.initProcessActivationListener();
    }

    private void initProcessInstanceManager() {
        String processInstanceManagerClass = ((SessionConfiguration)this.kruntime.getSessionConfiguration()).getProcessInstanceManagerFactory();
        try {
            this.processInstanceManager = ((ProcessInstanceManagerFactory)this.loadClass(processInstanceManagerClass).newInstance()).createProcessInstanceManager(this.kruntime);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void initSignalManager() {
        String signalManagerClass = ((SessionConfiguration)this.kruntime.getSessionConfiguration()).getSignalManagerFactory();
        try {
            this.signalManager = ((SignalManagerFactory)this.loadClass(signalManagerClass).newInstance()).createSignalManager(this.kruntime);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> loadClass(String className) {
        try {
            return this.getRootClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private ClassLoader getRootClassLoader() {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.kruntime.getKieBase();
        if (kbase != null) {
            return kbase.getRootClassLoader();
        }
        CompositeClassLoader result = new CompositeClassLoader();
        result.addClassLoader(Thread.currentThread().getContextClassLoader());
        return result;
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId) {
        return this.startProcess(processId, null);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        return this.startProcess(processId, parameters, null);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters, String trigger) {
        org.kie.api.runtime.process.ProcessInstance processInstance = this.createProcessInstance(processId, parameters);
        if (processInstance != null) {
            return this.startProcessInstance(processInstance.getId(), trigger);
        }
        return null;
    }

    public org.kie.api.runtime.process.ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        return this.createProcessInstance(processId, null, parameters);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcessFromNodeIds(String processId, Map<String, Object> parameters, String ... nodeInstancesIds) {
        return this.startProcessFromNodeIds(processId, null, parameters, nodeInstancesIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.kie.api.runtime.process.ProcessInstance startProcessFromNodeIds(String processId, CorrelationKey key, Map<String, Object> params, String ... nodeIds) {
        try {
            this.kruntime.startOperation();
            RuleFlowProcessInstance wfp = (RuleFlowProcessInstance)this.createProcessInstance(processId, key, params);
            wfp.configureSLA();
            this.getProcessEventSupport().fireBeforeProcessStarted((org.kie.api.runtime.process.ProcessInstance)wfp, (KieRuntime)this.kruntime);
            wfp.startProcessFromNodeIds(nodeIds);
            this.getProcessEventSupport().fireAfterProcessStarted((org.kie.api.runtime.process.ProcessInstance)wfp, (KieRuntime)this.kruntime);
            RuleFlowProcessInstance ruleFlowProcessInstance = wfp;
            return ruleFlowProcessInstance;
        }
        finally {
            this.kruntime.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.kie.api.runtime.process.ProcessInstance startProcessInstance(long processInstanceId, String trigger) {
        try {
            this.kruntime.startOperation();
            org.kie.api.runtime.process.ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
            ((ProcessInstance)processInstance).configureSLA();
            this.getProcessEventSupport().fireBeforeProcessStarted(processInstance, (KieRuntime)this.kruntime);
            ((ProcessInstance)processInstance).start(trigger);
            this.getProcessEventSupport().fireAfterProcessStarted(processInstance, (KieRuntime)this.kruntime);
            org.kie.api.runtime.process.ProcessInstance processInstance2 = processInstance;
            return processInstance2;
        }
        finally {
            this.kruntime.endOperation();
        }
    }

    public org.kie.api.runtime.process.ProcessInstance startProcessInstance(long processInstanceId) {
        return this.startProcessInstance(processInstanceId, null);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        org.kie.api.runtime.process.ProcessInstance processInstance = this.createProcessInstance(processId, correlationKey, parameters);
        if (processInstance != null) {
            return this.startProcessInstance(processInstance.getId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.kie.api.runtime.process.ProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        try {
            this.kruntime.startOperation();
            Process process = this.kruntime.getKieBase().getProcess(processId);
            if (process == null) {
                throw new IllegalArgumentException("Unknown process ID: " + processId);
            }
            ProcessInstance processInstance = this.startProcess(process, correlationKey, parameters);
            return processInstance;
        }
        finally {
            this.kruntime.endOperation();
        }
    }

    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        return this.processInstanceManager.getProcessInstance(correlationKey);
    }

    private ProcessInstance startProcess(Process process, CorrelationKey correlationKey, Map<String, Object> parameters) {
        ProcessInstanceFactory conf = ProcessInstanceFactoryRegistry.INSTANCE.getProcessInstanceFactory(process);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal process type: " + process.getClass());
        }
        return conf.createProcessInstance(process, correlationKey, this.kruntime, parameters);
    }

    @Override
    public ProcessInstanceManager getProcessInstanceManager() {
        return this.processInstanceManager;
    }

    @Override
    public TimerManager getTimerManager() {
        return this.timerManager;
    }

    @Override
    public SignalManager getSignalManager() {
        return this.signalManager;
    }

    public Collection<org.kie.api.runtime.process.ProcessInstance> getProcessInstances() {
        return this.processInstanceManager.getProcessInstances();
    }

    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(long id) {
        return this.getProcessInstance(id, false);
    }

    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(long id, boolean readOnly) {
        return this.processInstanceManager.getProcessInstance(id, readOnly);
    }

    public void removeProcessInstance(org.kie.api.runtime.process.ProcessInstance processInstance) {
        this.processInstanceManager.removeProcessInstance(processInstance);
    }

    public void initProcessEventListeners() {
        for (Process process : this.kruntime.getKieBase().getProcesses()) {
            this.initProcessEventListener(process);
        }
    }

    public void removeProcessEventListeners() {
        for (Process process : this.kruntime.getKieBase().getProcesses()) {
            this.removeProcessEventListener(process);
        }
    }

    private void removeProcessEventListener(Process process) {
        if (process instanceof RuleFlowProcess) {
            String type = (String)((RuleFlowProcess)process).getRuntimeMetaData().get("StartProcessEventType");
            StartProcessEventListener listener = (StartProcessEventListener)((RuleFlowProcess)process).getRuntimeMetaData().get("StartProcessEventListener");
            if (type != null && listener != null) {
                this.signalManager.removeEventListener(type, listener);
            }
        }
    }

    private void initProcessEventListener(Process process) {
        if (process instanceof RuleFlowProcess) {
            for (Node node : ((RuleFlowProcess)process).getNodes()) {
                List<Trigger> triggers;
                StartNode startNode;
                if (!(node instanceof StartNode) || (startNode = (StartNode)node) == null || (triggers = startNode.getTriggers()) == null) continue;
                for (Trigger trigger : triggers) {
                    if (!(trigger instanceof EventTrigger)) continue;
                    List<EventFilter> filters = ((EventTrigger)trigger).getEventFilters();
                    String type = null;
                    for (EventFilter filter : filters) {
                        if (!(filter instanceof EventTypeFilter)) continue;
                        type = ((EventTypeFilter)filter).getType();
                    }
                    StartProcessEventListener listener = new StartProcessEventListener(process.getId(), filters, trigger.getInMappings(), startNode.getEventTransformer());
                    this.signalManager.addEventListener(type, listener);
                    ((RuleFlowProcess)process).getRuntimeMetaData().put("StartProcessEventType", type);
                    ((RuleFlowProcess)process).getRuntimeMetaData().put("StartProcessEventListener", listener);
                }
            }
        }
    }

    @Override
    public ProcessEventSupport getProcessEventSupport() {
        return this.processEventSupport;
    }

    public void addEventListener(ProcessEventListener listener) {
        this.processEventSupport.addEventListener((java.util.EventListener)listener);
    }

    public void removeEventListener(ProcessEventListener listener) {
        this.processEventSupport.removeEventListener((java.util.EventListener)listener);
    }

    public List<ProcessEventListener> getProcessEventListeners() {
        return this.processEventSupport.getEventListeners();
    }

    private void initProcessActivationListener() {
        this.kruntime.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                String ruleFlowGroup = ((RuleImpl)event.getMatch().getRule()).getRuleFlowGroup();
                if ("DROOLS_SYSTEM".equals(ruleFlowGroup)) {
                    String rulePrefix;
                    String ruleName = event.getMatch().getRule().getName();
                    if (ruleName.startsWith(rulePrefix = "RuleFlowStateNode-")) {
                        int index = ruleName.lastIndexOf(45);
                        index = ruleName.lastIndexOf(45, index - 1);
                        String eventType = ruleName.substring(0, index);
                        ProcessRuntimeImpl.this.kruntime.queueWorkingMemoryAction((WorkingMemoryAction)new SignalManagerSignalAction(eventType, event));
                    } else if (ruleName.startsWith("RuleFlowStateEventSubProcess-") || ruleName.startsWith("RuleFlowStateEvent-") || ruleName.startsWith("RuleFlow-AdHocComplete-") || ruleName.startsWith("RuleFlow-AdHocActivate-")) {
                        ProcessRuntimeImpl.this.kruntime.queueWorkingMemoryAction((WorkingMemoryAction)new SignalManagerSignalAction(ruleName, event));
                    } else if (ruleName.startsWith("RuleFlow-Milestone-")) {
                        String caseId = (String)ProcessRuntimeImpl.this.kruntime.getEnvironment().get("CaseId");
                        if (caseId != null) {
                            ProcessRuntimeImpl.this.kruntime.queueWorkingMemoryAction((WorkingMemoryAction)new SignalManagerSignalAction(ruleName + "-" + caseId, event));
                        } else {
                            ProcessRuntimeImpl.this.kruntime.queueWorkingMemoryAction((WorkingMemoryAction)new SignalManagerSignalAction(ruleName, event));
                        }
                    }
                } else {
                    String ruleName = event.getMatch().getRule().getName();
                    if (ruleName.startsWith("RuleFlow-Start-")) {
                        String processId = ruleName.replace("RuleFlow-Start-", "");
                        ProcessRuntimeImpl.this.startProcessWithParamsAndTrigger(processId, null, "conditional", true);
                    }
                }
            }
        });
        this.kruntime.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
                if (ProcessRuntimeImpl.this.kruntime instanceof StatefulKnowledgeSession) {
                    ProcessRuntimeImpl.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName() + "_" + ((StatefulKnowledgeSession)ProcessRuntimeImpl.this.kruntime).getIdentifier(), null);
                } else {
                    ProcessRuntimeImpl.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName(), null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProcessWithParamsAndTrigger(String processId, Map<String, Object> params, String type, boolean dispose) {
        RuntimeManager manager = (RuntimeManager)this.kruntime.getEnvironment().get("RuntimeManager");
        if (manager != null) {
            ProcessInstanceIdContext context = ProcessInstanceIdContext.get();
            String caseId = (String)this.kruntime.getEnvironment().get("CaseId");
            if (caseId != null) {
                context = CaseContext.get((String)caseId);
            }
            RuntimeEngine runtime = manager.getRuntimeEngine((Context)context);
            KieSession ksession = runtime.getKieSession();
            try {
                ksession.execute((Command)new StartProcessWithTypeCommand(processId, params, type));
            }
            finally {
                if (dispose) {
                    manager.disposeRuntimeEngine(runtime);
                }
            }
        } else {
            this.startProcess(processId, params, type);
        }
    }

    public void abortProcessInstance(long processInstanceId) {
        org.kie.api.runtime.process.ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance for id " + processInstanceId);
        }
        ((ProcessInstance)processInstance).setState(3);
    }

    public WorkItemManager getWorkItemManager() {
        return this.kruntime.getWorkItemManager();
    }

    public void signalEvent(String type, Object event) {
        this.signalManager.signalEvent(type, event);
    }

    public void signalEvent(String type, Object event, long processInstanceId) {
        this.signalManager.signalEvent(processInstanceId, type, event);
    }

    public void setProcessEventSupport(ProcessEventSupport processEventSupport) {
        this.processEventSupport = processEventSupport;
    }

    public void dispose() {
        this.processEventSupport.reset();
        this.timerManager.dispose();
        this.kruntime = null;
    }

    public void clearProcessInstances() {
        this.processInstanceManager.clearProcessInstances();
    }

    public void clearProcessInstancesState() {
        this.processInstanceManager.clearProcessInstancesState();
    }

    public boolean isActive() {
        Boolean active = (Boolean)this.kruntime.getEnvironment().get("Active");
        if (active == null) {
            return true;
        }
        return active;
    }

    public class SignalManagerSignalAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private String type;
        private Object event;

        public SignalManagerSignalAction(String type, Object event) {
            this.type = type;
            this.event = event;
        }

        public SignalManagerSignalAction(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
            this.type = context.readUTF();
            if (context.readBoolean()) {
                this.event = context.readObject();
            }
        }

        public void execute(InternalWorkingMemory workingMemory) {
            ProcessRuntimeImpl.this.signalEvent(this.type, this.event);
        }

        public void execute(InternalKnowledgeRuntime kruntime) {
            ProcessRuntimeImpl.this.signalEvent(this.type, this.event);
        }

        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) throws IOException {
            return null;
        }
    }

    public static class RegisterStartTimerAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private List<StartNode> startNodes;
        private String processId;
        private TimerManager timerManager;

        public RegisterStartTimerAction(String processId, List<StartNode> startNodes, TimerManager timerManager) {
            this.processId = processId;
            this.startNodes = startNodes;
            this.timerManager = timerManager;
        }

        public RegisterStartTimerAction(MarshallerReaderContext context) {
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.initTimer(workingMemory.getKnowledgeRuntime());
        }

        public void execute(InternalKnowledgeRuntime kruntime) {
            this.initTimer(kruntime);
        }

        private void initTimer(InternalKnowledgeRuntime kruntime) {
            for (StartNode startNode : this.startNodes) {
                if (startNode == null || startNode.getTimer() == null) continue;
                TimerInstance timerInstance = null;
                if (startNode.getTimer().getDelay() != null && CronExpression.isValidExpression((String)startNode.getTimer().getDelay())) {
                    timerInstance = new TimerInstance();
                    timerInstance.setCronExpression(startNode.getTimer().getDelay());
                } else {
                    timerInstance = this.createTimerInstance(startNode.getTimer(), kruntime);
                }
                timerInstance.setName(startNode.getName());
                this.timerManager.registerTimer(timerInstance, this.processId, null);
            }
        }

        protected TimerInstance createTimerInstance(Timer timer, InternalKnowledgeRuntime kruntime) {
            TimerInstance timerInstance = new TimerInstance();
            if (kruntime != null && kruntime.getEnvironment().get("jbpm.business.calendar") != null) {
                BusinessCalendar businessCalendar = (BusinessCalendar)kruntime.getEnvironment().get("jbpm.business.calendar");
                String delay = timer.getDelay();
                timerInstance.setDelay(businessCalendar.calculateBusinessTimeAsDuration(delay));
                if (timer.getPeriod() == null) {
                    timerInstance.setPeriod(0L);
                } else {
                    String period = timer.getPeriod();
                    timerInstance.setPeriod(businessCalendar.calculateBusinessTimeAsDuration(period));
                }
            } else {
                this.configureTimerInstance(timer, timerInstance);
            }
            timerInstance.setTimerId(timer.getId());
            return timerInstance;
        }

        private void configureTimerInstance(Timer timer, TimerInstance timerInstance) {
            long duration = -1L;
            switch (timer.getTimeType()) {
                case 2: {
                    long[] repeatValues = DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                    if (repeatValues.length == 3) {
                        int parsedReapedCount = (int)repeatValues[0];
                        if (parsedReapedCount > -1) {
                            timerInstance.setRepeatLimit(parsedReapedCount + 1);
                        }
                        timerInstance.setDelay(repeatValues[1]);
                        timerInstance.setPeriod(repeatValues[2]);
                        break;
                    }
                    timerInstance.setDelay(repeatValues[0]);
                    try {
                        timerInstance.setPeriod(TimeUtils.parseTimeString((String)timer.getPeriod()));
                    }
                    catch (RuntimeException e) {
                        timerInstance.setPeriod(repeatValues[0]);
                    }
                    break;
                }
                case 1: {
                    duration = DateTimeUtils.parseDuration(timer.getDelay());
                    timerInstance.setDelay(duration);
                    timerInstance.setPeriod(0L);
                    break;
                }
                case 3: {
                    duration = DateTimeUtils.parseDateAsDuration(timer.getDate());
                    timerInstance.setDelay(duration);
                    timerInstance.setPeriod(0L);
                    break;
                }
            }
        }

        private long resolveValue(String s) {
            return TimeUtils.parseTimeString((String)s);
        }
    }

    private class StartProcessWithTypeCommand
    implements ExecutableCommand<Void> {
        private static final long serialVersionUID = -8890906804846111698L;
        private String processId;
        private Map<String, Object> params;
        private String type;

        private StartProcessWithTypeCommand(String processId, Map<String, Object> params, String type) {
            this.processId = processId;
            this.params = params;
            this.type = type;
        }

        public Void execute(org.kie.api.runtime.Context context) {
            KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
            ((ProcessRuntimeImpl)((InternalKnowledgeRuntime)ksession).getProcessRuntime()).startProcess(this.processId, this.params, this.type);
            return null;
        }
    }

    private class StartProcessEventListener
    implements EventListener {
        private String processId;
        private List<EventFilter> eventFilters;
        private Map<String, String> inMappings;
        private EventTransformer eventTransformer;

        public StartProcessEventListener(String processId, List<EventFilter> eventFilters, Map<String, String> inMappings, EventTransformer eventTransformer) {
            this.processId = processId;
            this.eventFilters = eventFilters;
            this.inMappings = inMappings;
            this.eventTransformer = eventTransformer;
        }

        public String[] getEventTypes() {
            return null;
        }

        public void signalEvent(String type, Object event) {
            for (EventFilter filter : this.eventFilters) {
                if (filter.acceptsEvent(type, event)) continue;
                return;
            }
            if (this.eventTransformer != null) {
                event = this.eventTransformer.transformEvent(event);
            }
            HashMap<String, Object> params = null;
            if (this.inMappings != null && !this.inMappings.isEmpty()) {
                params = new HashMap<String, Object>();
                if (this.inMappings.size() == 1) {
                    params.put(this.inMappings.keySet().iterator().next(), event);
                } else {
                    for (Map.Entry<String, String> entry : this.inMappings.entrySet()) {
                        if ("event".equals(entry.getValue())) {
                            params.put(entry.getKey(), event);
                            continue;
                        }
                        params.put(entry.getKey(), entry.getValue());
                    }
                }
            }
            ProcessRuntimeImpl.this.startProcessWithParamsAndTrigger(this.processId, params, type, false);
        }
    }
}

