/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.validation.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.validation.Validation;
import javax.validation.metadata.BeanDescriptor;
import org.jboss.errai.config.rebind.EnvUtil;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.validation.ContextModelConstraintsExtractor;
import org.kie.workbench.common.forms.dynamic.service.shared.impl.MapModelRenderingContext;
import org.kie.workbench.common.forms.dynamic.service.shared.impl.validation.DynamicModelConstraints;
import org.kie.workbench.common.forms.dynamic.service.shared.impl.validation.FieldConstraint;
import org.kie.workbench.common.forms.model.JavaFormModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
@Default
public class ContextModelConstraintsExtractorImpl
implements ContextModelConstraintsExtractor,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ContextModelConstraintsExtractorImpl.class);

    @Override
    public void readModelConstraints(MapModelRenderingContext clientRenderingContext, ClassLoader classLoader) {
        if (clientRenderingContext == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader cannot be null");
        }
        clientRenderingContext.getAvailableForms().values().forEach(formDefinition -> {
            if (formDefinition.getModel() instanceof JavaFormModel) {
                JavaFormModel javaModel = (JavaFormModel)formDefinition.getModel();
                if (clientRenderingContext.getModelConstraints().containsKey(javaModel)) {
                    return;
                }
                Class<?> clazz = null;
                try {
                    clazz = classLoader.loadClass(javaModel.getType());
                    if (clazz == null) {
                        this.getClass();
                        clazz = Class.forName(javaModel.getType());
                    }
                }
                catch (ClassNotFoundException e) {
                    try {
                        this.getClass();
                        clazz = Class.forName(javaModel.getType());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (clazz == null) {
                    logger.warn("Unable to find class for type {} on any classLoader. Skipping annotation processing", (Object)javaModel.getType());
                } else {
                    BeanDescriptor descriptor = Validation.buildDefaultValidatorFactory().getValidator().getConstraintsForClass(clazz);
                    Set properties = descriptor.getConstrainedProperties();
                    DynamicModelConstraints constraints = new DynamicModelConstraints(javaModel.getType());
                    clientRenderingContext.getModelConstraints().put(javaModel.getType(), constraints);
                    properties.forEach(property -> property.getConstraintDescriptors().forEach(constraintDescriptor -> {
                        HashMap attributes = new HashMap();
                        constraintDescriptor.getAttributes().forEach((key, value) -> {
                            if (key.equals("payload") || key.equals("groups")) {
                                return;
                            }
                            Object portableValue = EnvUtil.isPortableType(value.getClass()) ? value : value.toString();
                            attributes.put(key, portableValue);
                        });
                        constraints.addConstraintForField(property.getPropertyName(), new FieldConstraint(constraintDescriptor.getAnnotation().annotationType().getName(), attributes));
                    }));
                }
            }
        });
    }
}

