/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.backend.impl;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.PipelineConfig;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.guvnor.ala.services.api.PipelineService;
import org.guvnor.ala.services.api.backend.PipelineServiceBackend;
import org.guvnor.ala.services.exceptions.BusinessException;
import org.jboss.errai.bus.server.annotations.Service;

@Service
@ApplicationScoped
public class PipelineServiceBackendImpl
implements PipelineServiceBackend {
    private PipelineService pipelineService;

    public PipelineServiceBackendImpl() {
    }

    @Inject
    public PipelineServiceBackendImpl(PipelineService pipelineService) {
        this.pipelineService = pipelineService;
    }

    public List<PipelineConfig> getPipelineConfigs(Integer page, Integer pageSize, String sort, boolean sortOrder) throws BusinessException {
        return this.pipelineService.getPipelineConfigs(page, pageSize, sort, sortOrder).getItems();
    }

    public List<PipelineConfig> getPipelineConfigs(ProviderType providerType, Integer page, Integer pageSize, String sort, boolean sortOrder) throws BusinessException {
        return this.pipelineService.getPipelineConfigs(providerType.getProviderTypeName(), providerType.getVersion(), page, pageSize, sort, sortOrder).getItems();
    }

    public List<String> getPipelineNames(ProviderType providerType, Integer page, Integer pageSize, String sort, boolean sortOrder) throws BusinessException {
        return this.pipelineService.getPipelineNames(providerType.getProviderTypeName(), providerType.getVersion(), page, pageSize, sort, sortOrder);
    }

    public String newPipeline(PipelineConfig pipelineConfig, ProviderType providerType) throws BusinessException {
        return this.pipelineService.newPipeline(pipelineConfig, providerType);
    }

    public String newPipeline(PipelineConfig config) throws BusinessException {
        return this.pipelineService.newPipeline(config);
    }

    public String runPipeline(String id, Input input, boolean async) throws BusinessException {
        return this.pipelineService.runPipeline(id, input, async);
    }

    public void stopPipelineExecution(String executionId) throws BusinessException {
        this.pipelineService.stopPipelineExecution(executionId);
    }

    public void deletePipelineExecution(String executionId) throws BusinessException {
        this.pipelineService.deletePipelineExecution(executionId);
    }
}

