/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository.vfs;

import java.io.File;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.jbpm.designer.repository.vfs.RepositoryDescriptorProvider;
import org.jbpm.designer.server.service.PathEvent;
import org.jbpm.designer.util.Utils;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.spaces.Space;

@RequestScoped
public class RepositoryDescriptor {
    private static final String SEP = File.separator;
    @Inject
    private Instance<HttpServletRequest> httpRequest;
    @Inject
    private RepositoryDescriptorProvider provider;
    private URI repositoryRoot;
    private Path repositoryRootPath;
    private FileSystem fileSystem;
    private String path;
    private boolean configured = false;

    public RepositoryDescriptor() {
    }

    public RepositoryDescriptor(URI repositoryRoot, FileSystem fileSystem, Path repositoryRootPath) {
        this.repositoryRoot = repositoryRoot;
        this.fileSystem = fileSystem;
        this.repositoryRootPath = repositoryRootPath;
        this.configured = true;
    }

    public void onAnyDocumentEvent(@Observes PathEvent path) {
        this.path = path.getPath();
    }

    public String getStringRepositoryRoot() {
        String repo = this.repositoryRoot.toString();
        if (repo.endsWith("/")) {
            return repo.substring(0, repo.length() - 1);
        }
        return repo;
    }

    public URI getRepositoryRoot() {
        this.configure();
        return this.repositoryRoot;
    }

    public void setRepositoryRoot(URI repositoryRoot) {
        this.repositoryRoot = repositoryRoot;
    }

    public Path getRepositoryRootPath() {
        this.configure();
        return this.repositoryRootPath;
    }

    public void setRepositoryRootPath(Path repositoryRootPath) {
        this.repositoryRootPath = repositoryRootPath;
    }

    public FileSystem getFileSystem() {
        this.configure();
        return this.fileSystem;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    void configure() {
        Space space = null;
        String repositoryAlias = "";
        String branchName = "";
        if (!this.configured) {
            String uuid = Utils.getUUID((HttpServletRequest)this.httpRequest.get());
            if (uuid == null) {
                uuid = ((HttpServletRequest)this.httpRequest.get()).getParameter("assetId");
            }
            if (uuid == null && this.path != null) {
                uuid = this.path;
            }
            if (uuid != null) {
                Pattern pattern;
                if (uuid.indexOf("@") == -1) {
                    pattern = Pattern.compile(SEP + "(.*?)" + SEP + "(.*?)" + SEP);
                    Matcher matcher = pattern.matcher(uuid);
                    if (matcher.find()) {
                        space = new Space(matcher.group(1));
                        repositoryAlias = matcher.group(2);
                    }
                } else {
                    pattern = Pattern.compile("(://)(.*?)@(.*?)/(.*?)/");
                    Matcher matcher = pattern.matcher(uuid);
                    if (matcher.find()) {
                        branchName = matcher.group(2);
                        space = new Space(matcher.group(3));
                        repositoryAlias = matcher.group(4);
                    }
                }
            }
            if (space == null) {
                throw new IllegalStateException("Cannot parse space from uuid in request: " + uuid);
            }
            RepositoryDescriptor found = this.provider.getRepositoryDescriptor(space, repositoryAlias, branchName);
            this.fileSystem = found.getFileSystem();
            this.repositoryRoot = found.getRepositoryRoot();
            this.repositoryRootPath = found.getRepositoryRootPath();
        }
    }
}

