/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workitem.google.maps;

import com.google.maps.GeoApiContext;
import com.google.maps.RoadsApi;
import com.google.maps.model.SpeedLimit;
import java.util.HashMap;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.workitem.google.maps.GoogleMapsAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="GoogleMapsSpeedLimitsDefinitions.wid", name="GoogleMapsSpeedLimits", displayName="GoogleMapsSpeedLimits", defaultHandler="mvel: new org.jbpm.process.workitem.google.maps.SpeedLimitsWorkitemHandler(\"apiKey\")", documentation="google-maps-workitem/index.html", category="google-maps-workitem", icon="GoogleMapsSpeedLimits.png", parameters={@WidParameter(name="PlaceIds", required=true)}, results={@WidResult(name="Speedlimits", runtimeType="com.google.maps.model.SpeedLimit")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="google-maps-workitem", version="7.45.0-SNAPSHOT")}, serviceInfo=@WidService(category="Google Maps", description="Interact with Google Maps Services", keywords="google,maps,speedlimit,places", action=@WidAction(title="Get speedlimits for places using Google Maps"), authinfo=@WidAuth(required=true, params={"apiKey"}, paramsdescription={"Google maps api key"}, referencesite="https://developers.google.com/maps/premium/previous-licenses/clientside/auth")))
public class SpeedLimitsWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String apiKey;
    private GeoApiContext geoApiContext;
    private GoogleMapsAuth auth = new GoogleMapsAuth();
    private static final String RESULTS_VALUE = "Speedlimits";

    public SpeedLimitsWorkitemHandler(String apiKey) throws Exception {
        this.apiKey = apiKey;
        try {
            this.geoApiContext = this.auth.authorize(apiKey);
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with google maps: " + e.getMessage());
        }
    }

    public SpeedLimitsWorkitemHandler(GeoApiContext geoApiContext) {
        this.geoApiContext = geoApiContext;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        String[] placeIds = ((String)workItem.getParameter("PlaceIds")).split(",");
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            HashMap<String, SpeedLimit[]> results = new HashMap<String, SpeedLimit[]>();
            SpeedLimit[] speedLimits = (SpeedLimit[])RoadsApi.speedLimits((GeoApiContext)this.geoApiContext, (String[])placeIds).await();
            results.put(RESULTS_VALUE, speedLimits);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }
}

