/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.integration.service;

import java.util.Objects;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.stunner.core.util.HashUtil;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.uberfire.backend.vfs.Path;

@Portable
public class MigrateRequest {
    private Type type;
    private Path path;
    private String newName;
    private String newExtension;
    private String commitMessage;
    private ProjectDiagram projectDiagram;

    private MigrateRequest(@MapsTo(value="type") Type type, @MapsTo(value="path") Path path, @MapsTo(value="newName") String newName, @MapsTo(value="newExtension") String newExtension, @MapsTo(value="commitMessage") String commitMessage, @MapsTo(value="projectDiagram") ProjectDiagram projectDiagram) {
        this.type = type;
        this.path = path;
        this.newName = newName;
        this.newExtension = newExtension;
        this.commitMessage = commitMessage;
        this.projectDiagram = projectDiagram;
    }

    public Type getType() {
        return this.type;
    }

    public Path getPath() {
        return this.path;
    }

    public String getNewName() {
        return this.newName;
    }

    public String getNewExtension() {
        return this.newExtension;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public ProjectDiagram getProjectDiagram() {
        return this.projectDiagram;
    }

    public static MigrateRequest newFromStunnerToJBPMDesigner(Path path, String newName, String newExtension, String commitMessage) {
        return new MigrateRequest(Type.STUNNER_TO_JBPM_DESIGNER, path, newName, newExtension, commitMessage, null);
    }

    public static MigrateRequest newFromJBPMDesignerToStunner(Path path, String newName, String newExtension, String commitMessage, ProjectDiagram projectDiagram) {
        return new MigrateRequest(Type.JBPM_DESIGNER_TO_STUNNER, path, newName, newExtension, commitMessage, projectDiagram);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrateRequest request = (MigrateRequest)o;
        return this.type == request.type && Objects.equals(this.path, request.path) && Objects.equals(this.newName, request.newName) && Objects.equals(this.newExtension, request.newExtension) && Objects.equals(this.commitMessage, request.commitMessage) && Objects.equals(this.projectDiagram, request.projectDiagram);
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{Objects.hashCode((Object)this.type), Objects.hashCode(this.path), Objects.hashCode(this.newName), Objects.hashCode(this.newExtension), Objects.hashCode(this.commitMessage), Objects.hashCode(this.projectDiagram)});
    }

    public static enum Type {
        STUNNER_TO_JBPM_DESIGNER,
        JBPM_DESIGNER_TO_STUNNER;

    }
}

