/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.arifacts;

import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.TextAnnotation;
import org.kie.workbench.common.stunner.bpmn.backend.converters.NodeMatch;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.DataObjectPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.TextAnnotationPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.definition.BaseArtifacts;
import org.kie.workbench.common.stunner.bpmn.definition.DataObject;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class ArtifactsConverter {
    private final PropertyWriterFactory propertyWriterFactory;

    public ArtifactsConverter(PropertyWriterFactory propertyWriterFactory) {
        this.propertyWriterFactory = propertyWriterFactory;
    }

    public PropertyWriter toElement(Node<View<BaseArtifacts>, ?> node) {
        return NodeMatch.fromNode(BaseArtifacts.class, PropertyWriter.class).when(org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation.class, this::toTextAnnotation).when(DataObject.class, this::toDataObjectAnnotation).ignore(Object.class).apply(node).value();
    }

    private PropertyWriter toTextAnnotation(Node<View<org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation>, ?> node) {
        TextAnnotation element = Factories.bpmn2.createTextAnnotation();
        element.setId(node.getUUID());
        TextAnnotationPropertyWriter writer = this.propertyWriterFactory.of(element);
        org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation definition = (org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation)((View)node.getContent()).getDefinition();
        BPMNGeneralSet general = definition.getGeneral();
        writer.setName(general.getName().getValue());
        writer.setDocumentation(general.getDocumentation().getValue());
        writer.setAbsoluteBounds(node);
        return writer;
    }

    private PropertyWriter toDataObjectAnnotation(Node<View<DataObject>, ?> node) {
        DataObjectReference element = Factories.bpmn2.createDataObjectReference();
        element.setId(node.getUUID());
        DataObjectPropertyWriter writer = this.propertyWriterFactory.of(element);
        DataObject definition = (DataObject)((View)node.getContent()).getDefinition();
        writer.setName(StringUtils.replaceIllegalCharsAttribute((String)StringUtils.replaceIllegalCharsForDataObjects((String)definition.getName().getValue())));
        writer.setType(definition.getType().getValue().getType());
        writer.setAbsoluteBounds(node);
        return writer;
    }
}

