/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.workbench.ks.integration.AbstractKieServerService;
import org.jbpm.workbench.pr.backend.server.NodeInstanceSummaryMapper;
import org.jbpm.workbench.pr.backend.server.ProcessInstanceSummaryMapper;
import org.jbpm.workbench.pr.backend.server.ProcessSummaryMapper;
import org.jbpm.workbench.pr.backend.server.TimerInstanceSummaryMapper;
import org.jbpm.workbench.pr.backend.server.WorkItemSummaryMapper;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessDefinitionKey;
import org.jbpm.workbench.pr.model.ProcessInstanceDiagramSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceKey;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.model.TaskDefSummary;
import org.jbpm.workbench.pr.model.TimerInstanceSummary;
import org.jbpm.workbench.pr.model.WorkItemSummary;
import org.jbpm.workbench.pr.service.ProcessImageService;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationProperty;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.UserTaskDefinitionList;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.WorkItemInstance;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.admin.ProcessAdminServicesClient;

@Service
@ApplicationScoped
public class RemoteProcessRuntimeDataServiceImpl
extends AbstractKieServerService
implements ProcessRuntimeDataService {
    public static int NOT_FOUND_ERROR_CODE = 404;
    @Inject
    private ProcessImageService processImageService;

    public ProcessInstanceSummary getProcessInstance(ProcessInstanceKey processInstanceKey) {
        if (processInstanceKey == null || !processInstanceKey.isValid().booleanValue()) {
            return null;
        }
        QueryServicesClient queryServicesClient = (QueryServicesClient)this.getClient(processInstanceKey.getServerTemplateId(), QueryServicesClient.class);
        ProcessInstance processInstance = queryServicesClient.findProcessInstanceById(processInstanceKey.getProcessInstanceId());
        return new ProcessInstanceSummaryMapper(processInstanceKey.getServerTemplateId()).apply(processInstance);
    }

    private List<ProcessInstanceSummary> getProcessInstancesByParentId(ProcessInstanceKey processInstanceKey, String containerId) {
        if (processInstanceKey == null || !processInstanceKey.isValid().booleanValue()) {
            return null;
        }
        ProcessServicesClient processServicesClient = (ProcessServicesClient)this.getClient(processInstanceKey.getServerTemplateId(), ProcessServicesClient.class);
        List processInstances = processServicesClient.findProcessInstancesByParent(containerId, processInstanceKey.getProcessInstanceId(), Arrays.asList(1, 2, 3, 0, 4), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        ProcessInstanceSummaryMapper processInstanceSummaryMapper = new ProcessInstanceSummaryMapper(processInstanceKey.getServerTemplateId());
        return processInstances.stream().map(processInstanceSummaryMapper).collect(Collectors.toList());
    }

    public List<NodeInstanceSummary> getProcessInstanceActiveNodes(ProcessInstanceKey processInstanceKey) {
        if (processInstanceKey == null || !processInstanceKey.isValid().booleanValue()) {
            return Collections.emptyList();
        }
        QueryServicesClient queryServicesClient = (QueryServicesClient)this.getClient(processInstanceKey.getServerTemplateId(), QueryServicesClient.class);
        List nodeInstances = queryServicesClient.findActiveNodeInstances(processInstanceKey.getProcessInstanceId(), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        return nodeInstances.stream().map(new NodeInstanceSummaryMapper()).collect(Collectors.toList());
    }

    public List<NodeInstanceSummary> getProcessInstanceCompletedNodes(ProcessInstanceKey processInstanceKey) {
        if (processInstanceKey == null || !processInstanceKey.isValid().booleanValue()) {
            return Collections.emptyList();
        }
        QueryServicesClient queryServicesClient = (QueryServicesClient)this.getClient(processInstanceKey.getServerTemplateId(), QueryServicesClient.class);
        List nodeInstances = queryServicesClient.findCompletedNodeInstances(processInstanceKey.getProcessInstanceId(), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        return nodeInstances.stream().map(new NodeInstanceSummaryMapper()).collect(Collectors.toList());
    }

    public ProcessInstanceDiagramSummary getProcessInstanceDiagramSummary(ProcessInstanceKey processInstanceKey, String completedNodeColor, String completedNodeBorderColor, String activeNodeBorderColor) {
        if (processInstanceKey == null || !processInstanceKey.isValid().booleanValue()) {
            return null;
        }
        ProcessInstanceSummary processInstance = this.getProcessInstance(processInstanceKey);
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setId(processInstance.getId());
        summary.setName(processInstance.getName());
        summary.setSvgContent(this.processImageService.getProcessInstanceDiagram(processInstanceKey.getServerTemplateId(), processInstanceKey.getDeploymentId(), processInstanceKey.getProcessInstanceId(), completedNodeColor, completedNodeBorderColor, activeNodeBorderColor));
        summary.setProcessDefinition(this.getProcess(new ProcessDefinitionKey(processInstance.getServerTemplateId(), processInstance.getDeploymentId(), processInstance.getProcessId())));
        summary.setSubProcessInstances(this.getProcessInstancesByParentId(processInstanceKey, processInstanceKey.getDeploymentId()));
        if (processInstance.getParentId() != -1L) {
            summary.setParentProcessInstanceSummary(this.getProcessInstance(new ProcessInstanceKey(processInstanceKey.getServerTemplateId(), "", processInstance.getParentId())));
        } else {
            summary.setParentProcessInstanceSummary(null);
        }
        if (processInstance.getState() == 1) {
            List<NodeInstanceSummary> nodeInstances = this.getProcessInstanceActiveNodes(processInstanceKey);
            nodeInstances.addAll(this.getProcessInstanceCompletedNodes(processInstanceKey));
            summary.setNodeInstances(nodeInstances);
            summary.setTimerInstances(this.getProcessInstanceTimerInstances(processInstanceKey));
        } else {
            summary.setNodeInstances(Collections.emptyList());
            summary.setTimerInstances(Collections.emptyList());
        }
        return summary;
    }

    public List<TimerInstanceSummary> getProcessInstanceTimerInstances(ProcessInstanceKey processInstanceKey) {
        if (processInstanceKey == null || !processInstanceKey.isValid().booleanValue()) {
            return Collections.emptyList();
        }
        ProcessAdminServicesClient servicesClient = (ProcessAdminServicesClient)this.getClient(processInstanceKey.getServerTemplateId(), ProcessAdminServicesClient.class);
        return servicesClient.getTimerInstances(processInstanceKey.getDeploymentId(), processInstanceKey.getProcessInstanceId()).stream().map(new TimerInstanceSummaryMapper()).collect(Collectors.toList());
    }

    public void triggerProcessInstanceNode(ProcessInstanceKey processInstanceKey, Long nodeId) {
        if (processInstanceKey == null || !processInstanceKey.isValid().booleanValue()) {
            return;
        }
        ProcessAdminServicesClient servicesClient = (ProcessAdminServicesClient)this.getClient(processInstanceKey.getServerTemplateId(), ProcessAdminServicesClient.class);
        servicesClient.triggerNode(processInstanceKey.getDeploymentId(), processInstanceKey.getProcessInstanceId(), nodeId);
    }

    public void cancelProcessInstanceNode(ProcessInstanceKey processInstanceKey, Long nodeInstanceId) {
        if (processInstanceKey == null || !processInstanceKey.isValid().booleanValue()) {
            return;
        }
        ProcessAdminServicesClient servicesClient = (ProcessAdminServicesClient)this.getClient(processInstanceKey.getServerTemplateId(), ProcessAdminServicesClient.class);
        servicesClient.cancelNodeInstance(processInstanceKey.getDeploymentId(), processInstanceKey.getProcessInstanceId(), nodeInstanceId);
    }

    public void reTriggerProcessInstanceNode(ProcessInstanceKey processInstanceKey, Long nodeInstanceId) {
        if (processInstanceKey == null || !processInstanceKey.isValid().booleanValue()) {
            return;
        }
        ProcessAdminServicesClient servicesClient = (ProcessAdminServicesClient)this.getClient(processInstanceKey.getServerTemplateId(), ProcessAdminServicesClient.class);
        servicesClient.retriggerNodeInstance(processInstanceKey.getDeploymentId(), processInstanceKey.getProcessInstanceId(), nodeInstanceId);
    }

    public void rescheduleTimerInstance(ProcessInstanceKey processInstanceKey, TimerInstanceSummary summary) {
        if (processInstanceKey == null || !processInstanceKey.isValid().booleanValue()) {
            return;
        }
        ProcessAdminServicesClient servicesClient = (ProcessAdminServicesClient)this.getClient(processInstanceKey.getServerTemplateId(), ProcessAdminServicesClient.class);
        if (summary.isRelative().booleanValue()) {
            servicesClient.updateTimerRelative(processInstanceKey.getDeploymentId(), processInstanceKey.getProcessInstanceId(), ((Long)summary.getId()).longValue(), summary.getDelay().longValue(), summary.getPeriod().longValue(), summary.getRepeatLimit().intValue());
        } else {
            servicesClient.updateTimer(processInstanceKey.getDeploymentId(), processInstanceKey.getProcessInstanceId(), ((Long)summary.getId()).longValue(), summary.getDelay().longValue(), summary.getPeriod().longValue(), summary.getRepeatLimit().intValue());
        }
    }

    public List<ProcessSummary> getProcesses(String serverTemplateId, Integer page, Integer pageSize, String sort, Boolean sortOrder) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        QueryServicesClient queryServicesClient = (QueryServicesClient)this.getClient(serverTemplateId, QueryServicesClient.class);
        List processes = queryServicesClient.findProcesses(page, pageSize, sort, sortOrder.booleanValue());
        return processes.stream().map(new ProcessSummaryMapper()).collect(Collectors.toList());
    }

    public ProcessSummary getProcess(ProcessDefinitionKey processDefinitionKey) {
        if (processDefinitionKey == null || !processDefinitionKey.isValid().booleanValue()) {
            return null;
        }
        ProcessServicesClient queryServicesClient = (ProcessServicesClient)this.getClient(processDefinitionKey.getServerTemplateId(), ProcessServicesClient.class);
        ProcessDefinition definition = queryServicesClient.getProcessDefinition(processDefinitionKey.getDeploymentId(), processDefinitionKey.getProcessId());
        return new ProcessSummaryMapper().apply(definition);
    }

    public List<ProcessSummary> getProcessesByFilter(String serverTemplateId, String textSearch, Integer page, Integer pageSize, String sort, Boolean sortOrder) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        QueryServicesClient queryServicesClient = (QueryServicesClient)this.getClient(serverTemplateId, QueryServicesClient.class);
        List processes = queryServicesClient.findProcesses(textSearch, page, pageSize, sort, sortOrder.booleanValue());
        return processes.stream().map(new ProcessSummaryMapper()).collect(Collectors.toList());
    }

    public List<TaskDefSummary> getProcessUserTasks(String serverTemplateId, String containerId, String processId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        ProcessServicesClient processServicesClient = (ProcessServicesClient)this.getClient(serverTemplateId, ProcessServicesClient.class);
        UserTaskDefinitionList userTaskDefinitionList = processServicesClient.getUserTaskDefinitions(containerId, processId);
        return userTaskDefinitionList.getItems().stream().map(t -> new TaskDefSummary(t.getName())).collect(Collectors.toList());
    }

    public WorkItemSummary getWorkItemByProcessInstanceId(String serverTemplateId, String containerId, Long processInstanceId, Long workItemId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return null;
        }
        ProcessServicesClient processServicesClient = (ProcessServicesClient)this.getClient(serverTemplateId, ProcessServicesClient.class);
        try {
            WorkItemInstance workItem = processServicesClient.getWorkItem(containerId, processInstanceId, workItemId);
            return new WorkItemSummaryMapper().apply(workItem);
        }
        catch (KieServicesHttpException kieException) {
            if (kieException.getHttpCode() == NOT_FOUND_ERROR_CODE) {
                return null;
            }
            throw kieException;
        }
    }

    public ProcessInstanceSummary getProcessInstanceByCorrelationKey(String serverTemplateId, final String correlationKey) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return null;
        }
        QueryServicesClient queryServicesClient = (QueryServicesClient)this.getClient(serverTemplateId, QueryServicesClient.class);
        ProcessInstance processInstance = queryServicesClient.findProcessInstanceByCorrelationKey(new CorrelationKey(){

            public String toExternalForm() {
                return correlationKey;
            }

            public List<CorrelationProperty<?>> getProperties() {
                return null;
            }

            public String getName() {
                return correlationKey;
            }
        });
        return new ProcessInstanceSummaryMapper(serverTemplateId).apply(processInstance);
    }
}

