/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.api;

import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.definition.DefinitionFactory;
import org.kie.workbench.common.stunner.core.factory.diagram.DiagramFactory;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.factory.graph.GraphFactory;
import org.kie.workbench.common.stunner.core.factory.impl.DiagramFactoryImpl;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.registry.RegistryFactory;
import org.kie.workbench.common.stunner.core.registry.factory.FactoryRegistry;
import org.kie.workbench.common.stunner.core.util.UUID;

public abstract class AbstractFactoryManager {
    private final FactoryRegistry factoryRegistry;
    private final DefinitionManager definitionManager;

    public AbstractFactoryManager(RegistryFactory registryFactory, DefinitionManager definitionManager) {
        this.factoryRegistry = null != registryFactory ? registryFactory.newFactoryRegistry() : null;
        this.definitionManager = definitionManager;
    }

    protected AbstractFactoryManager(DefinitionManager definitionManager) {
        this.factoryRegistry = null;
        this.definitionManager = definitionManager;
    }

    public <T> T newDefinition(String id) {
        DefinitionFactory factory = this.factoryRegistry.getDefinitionFactory(id);
        return (T)factory.build(id);
    }

    public Element<?> newElement(String uuid, String id) {
        return this.newElement(uuid, id, null);
    }

    private Element<?> newElement(String uuid, String id, Metadata metadata) {
        Object defSet = this.getDefinitionSet(id);
        boolean isDefSet = null != defSet;
        return !isDefSet ? this.doBuildElement(uuid, id) : this.doBuildGraph(uuid, id, defSet, metadata);
    }

    private Object getDefinitionSet(String id) {
        return this.definitionManager.definitionSets().getDefinitionSetById(id);
    }

    public <M extends Metadata, D extends Diagram> D newDiagram(String name, String id, M metadata) {
        Graph graph = (Graph)this.newElement(UUID.uuid(), id, metadata);
        return (D)this.checkDiagramFactoryNotNull((String)((DefinitionSet)graph.getContent()).getDefinition(), metadata).build(name, metadata, graph);
    }

    private <M extends Metadata> DiagramFactory<M, ?> checkDiagramFactoryNotNull(String defSetid, M metadata) {
        DiagramFactory factory = this.registry().getDiagramFactory(defSetid, metadata.getMetadataType());
        if (null == factory) {
            return new DiagramFactoryImpl();
        }
        return factory;
    }

    public FactoryRegistry registry() {
        return this.factoryRegistry;
    }

    protected DefinitionManager getDefinitionManager() {
        return this.definitionManager;
    }

    private <T, C extends Definition<T>> Element<C> doBuildElement(String uuid, String definitionId) {
        T definition = this.newDefinition(definitionId);
        Class factoryType = this.definitionManager.adapters().forDefinition().getGraphFactoryType(definition);
        ElementFactory factory = this.factoryRegistry.getElementFactory(factoryType);
        return factory.build(uuid, definition);
    }

    private <C extends DefinitionSet> Element<C> doBuildGraph(String uuid, String defSetId, Object defSet, Metadata metadata) {
        Class factoryType = this.definitionManager.adapters().forDefinitionSet().getGraphFactoryType(defSet);
        ElementFactory _factory = this.factoryRegistry.getElementFactory(factoryType);
        ElementFactory factory = null != _factory ? _factory : this.factoryRegistry.getElementFactory(GraphFactory.class);
        return factory.build(uuid, (Object)defSetId, metadata);
    }
}

