/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.registry.RegistryFactory;
import org.kie.workbench.common.stunner.core.registry.rule.RuleHandlerRegistry;
import org.kie.workbench.common.stunner.core.rule.Rule;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationHandler;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.rule.RuleSet;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtension;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtensionHandler;
import org.kie.workbench.common.stunner.core.rule.violations.ContextOperationNotAllowedViolation;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;

@Dependent
@Typed(value={RuleManagerImpl.class})
public class RuleManagerImpl
implements RuleManager {
    private final RuleHandlerRegistry registry;
    private RulesProvider rulesProvider;
    private RuleEvaluator ruleEvaluator;

    @Inject
    public RuleManagerImpl(RegistryFactory registryFactory) {
        this.registry = null != registryFactory ? registryFactory.newRuleHandlerRegistry() : null;
        this.rulesProvider = new RulesFromRuleSetProvider();
        this.ruleEvaluator = new DefaultRuleEvaluator();
    }

    public RuleManagerImpl(RuleHandlerRegistry registry) {
        this.registry = registry;
        this.rulesProvider = new RulesFromRuleSetProvider();
        this.ruleEvaluator = new DefaultRuleEvaluator();
    }

    public RuleManagerImpl setRulesProvider(RulesProvider rulesProvider) {
        this.rulesProvider = rulesProvider;
        return this;
    }

    public RuleManagerImpl setRuleEvaluator(RuleEvaluator ruleEvaluator) {
        this.ruleEvaluator = ruleEvaluator;
        return this;
    }

    public RuleViolations evaluate(RuleSet ruleSet, RuleEvaluationContext context) {
        DefaultRuleViolations results = new DefaultRuleViolations();
        Collection<Rule> rules = this.rulesProvider.get(ruleSet, context);
        if (rules.isEmpty()) {
            return results;
        }
        Collection handlers = this.registry.getHandlersByContext(context.getType());
        List handlersViolations = rules.stream().filter(rule -> !RuleManagerImpl.isRuleExtension().test((Rule)rule)).map(rule -> this.evaluate((Rule)rule, handlers, context)).collect(Collectors.toList());
        if (context.isDefaultDeny() && !handlersViolations.stream().anyMatch(Optional::isPresent)) {
            return this.getDefaultViolationForContext(context);
        }
        handlersViolations.stream().filter(Optional::isPresent).map(Optional::get).forEach(results::addViolations);
        rules.stream().filter(rule -> RuleManagerImpl.isRuleExtension().test((Rule)rule)).map(rule -> this.evaluateExtension((RuleExtension)rule, context)).filter(Optional::isPresent).map(Optional::get).forEach(results::addViolations);
        return results;
    }

    private Optional<RuleViolations> evaluate(Rule rule, Collection<RuleEvaluationHandler> handlers, RuleEvaluationContext context) {
        return RuleManagerImpl.isRuleExtension().test(rule) ? this.evaluateExtension((RuleExtension)rule, context) : this.evaluateRule(rule, handlers, context);
    }

    private RuleViolations getDefaultViolationForContext(RuleEvaluationContext context) {
        return new DefaultRuleViolations().addViolation(new ContextOperationNotAllowedViolation(context));
    }

    public RuleHandlerRegistry registry() {
        return this.registry;
    }

    @PreDestroy
    public void destroy() {
        this.registry().clear();
        this.rulesProvider = null;
        this.ruleEvaluator = null;
    }

    private Optional<RuleViolations> evaluateRule(Rule rule, Collection<RuleEvaluationHandler> evaluationHandlers, RuleEvaluationContext context) {
        Collection<RuleEvaluationHandler> handlers = this.getHandler(rule, evaluationHandlers, context);
        DefaultRuleViolations results = new DefaultRuleViolations();
        if (!handlers.isEmpty()) {
            handlers.forEach(h -> results.addViolations(h.evaluate(rule, context)));
            return Optional.of(results);
        }
        return Optional.empty();
    }

    private Optional<RuleViolations> evaluateExtension(RuleExtension rule, RuleEvaluationContext context) {
        Optional<RuleExtensionHandler> handler = this.getExtensionHandler(rule, context);
        return handler.isPresent() ? Optional.of(handler.get().evaluate((Rule)rule, context)) : Optional.empty();
    }

    private Collection<RuleEvaluationHandler> getHandler(Rule rule, Collection<RuleEvaluationHandler> handlers, RuleEvaluationContext context) {
        return handlers.stream().filter(h -> this.accepts((RuleEvaluationHandler)h, rule, context)).collect(Collectors.toList());
    }

    private Optional<RuleExtensionHandler> getExtensionHandler(RuleExtension rule, RuleEvaluationContext context) {
        RuleExtensionHandler handler = this.registry.getExtensionHandler(rule.getHandlerType());
        return null != handler && this.accepts((RuleEvaluationHandler)handler, (Rule)rule, context) ? Optional.of(handler) : Optional.empty();
    }

    private boolean accepts(RuleEvaluationHandler handler, Rule rule, RuleEvaluationContext context) {
        return this.ruleEvaluator.accepts(handler, rule, context);
    }

    public static Predicate<Rule> isRuleExtension() {
        return rule -> rule instanceof RuleExtension;
    }

    public static BiPredicate<Rule, RuleEvaluationHandler> isRuleTypeAllowed() {
        return (rule, handler) -> handler.getRuleType().equals(rule.getClass());
    }

    public static boolean accepts(RuleEvaluationHandler handler, RuleEvaluationContext context) {
        return handler.getContextType().equals(context.getType()) || RuleEvaluationContext.class.equals((Object)handler.getContextType());
    }

    public static class DefaultRuleEvaluator
    implements RuleEvaluator {
        @Override
        public boolean accepts(RuleEvaluationHandler handler, Rule rule, RuleEvaluationContext context) {
            return this.accepts(handler, rule) && this.accepts(handler, context) && handler.accepts(rule, context);
        }

        public boolean accepts(RuleEvaluationHandler handler, Rule rule) {
            return RuleManagerImpl.isRuleTypeAllowed().test(rule, handler);
        }

        public boolean accepts(RuleEvaluationHandler handler, RuleEvaluationContext context) {
            return RuleManagerImpl.accepts(handler, context);
        }
    }

    public static interface RuleEvaluator {
        public boolean accepts(RuleEvaluationHandler var1, Rule var2, RuleEvaluationContext var3);
    }

    public static class RulesFromRuleSetProvider
    implements RulesProvider {
        @Override
        public Collection<Rule> get(RuleSet ruleSet, RuleEvaluationContext context) {
            return ruleSet.getRules();
        }
    }

    public static interface RulesProvider {
        public Collection<Rule> get(RuleSet var1, RuleEvaluationContext var2);
    }
}

