/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.rule.ext;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.core.rule.Rule;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtension;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtensionHandler;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;

@Dependent
public class RuleExtensionMultiHandler
extends RuleExtensionHandler<RuleExtensionHandler, RuleEvaluationContext> {
    private final List<RuleExtensionHandler> handlers = new LinkedList<RuleExtensionHandler>();

    public boolean addHandler(RuleExtensionHandler handler) {
        return this.handlers.add(handler);
    }

    public Class<RuleExtensionHandler> getExtensionType() {
        return RuleExtensionHandler.class;
    }

    public Class<RuleEvaluationContext> getContextType() {
        return RuleEvaluationContext.class;
    }

    public boolean accepts(RuleExtension rule, RuleEvaluationContext context) {
        return this.handlers.stream().anyMatch(h -> this.isHandlerAccepted((RuleExtensionHandler)h, rule, context));
    }

    public RuleViolations evaluate(RuleExtension rule, RuleEvaluationContext context) {
        List<RuleExtensionHandler> candidates = this.handlers.stream().filter(h -> this.isHandlerAccepted((RuleExtensionHandler)h, rule, context)).collect(Collectors.toList());
        DefaultRuleViolations result = new DefaultRuleViolations();
        candidates.forEach(candidate -> result.addViolations(candidate.evaluate((Rule)rule, context)));
        return result;
    }

    private boolean isHandlerAccepted(RuleExtensionHandler handler, RuleExtension rule, RuleEvaluationContext context) {
        return handler.getContextType().equals(context.getType()) && handler.accepts((Rule)rule, context);
    }
}

