/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.workbench.client.entrypoint;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.RootPanel;
import java.util.Map;
import javax.inject.Inject;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.bus.client.framework.AbstractRpcProxy;
import org.jboss.errai.bus.client.util.BusToolsCli;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.jboss.errai.ioc.client.api.UncaughtExceptionHandler;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.resources.RoundedCornersResource;
import org.kie.workbench.common.workbench.client.entrypoint.GenericErrorPopup;
import org.kie.workbench.common.workbench.client.error.DefaultWorkbenchErrorCallback;
import org.uberfire.client.mvp.ActivityBeansCache;

public abstract class DefaultWorkbenchEntryPoint {
    protected Caller<AppConfigService> appConfigService;
    protected ActivityBeansCache activityBeansCache;
    private DefaultWorkbenchErrorCallback defaultWorkbenchErrorCallback;
    private GenericErrorPopup genericErrorPopup;

    @Inject
    public DefaultWorkbenchEntryPoint(Caller<AppConfigService> appConfigService, ActivityBeansCache activityBeansCache, DefaultWorkbenchErrorCallback defaultWorkbenchErrorCallback) {
        this.appConfigService = appConfigService;
        this.activityBeansCache = activityBeansCache;
        this.defaultWorkbenchErrorCallback = defaultWorkbenchErrorCallback;
    }

    @Inject
    public void setGenericErrorPopup(GenericErrorPopup genericErrorPopup) {
        this.genericErrorPopup = genericErrorPopup;
    }

    protected abstract void setupMenu();

    protected void setupAdminPage() {
    }

    @AfterInitialization
    public void startDefaultWorkbench() {
        this.initializeWorkbench();
    }

    @UncaughtExceptionHandler
    private void handleUncaughtException(Throwable t) {
        this.defaultWorkbenchErrorCallback.error(t);
    }

    void loadPreferences() {
        ((AppConfigService)this.appConfigService.call(response -> {
            ApplicationPreferences.setUp((Map)response);
            this.setupMenu();
            this.setupAdminPage();
        })).loadPreferences();
    }

    void loadStyles() {
        RoundedCornersResource.INSTANCE.roundCornersCss().ensureInjected();
    }

    @AfterInitialization
    public void hideLoadingPopup() {
        Element e = RootPanel.get((String)"loading").getElement();
        new Animation((com.google.gwt.dom.client.Element)e){
            final /* synthetic */ com.google.gwt.dom.client.Element val$e;
            {
                this.val$e = element;
            }

            protected void onUpdate(double progress) {
                this.val$e.getStyle().setOpacity(1.0 - progress);
            }

            protected void onComplete() {
                this.val$e.getStyle().setVisibility(Style.Visibility.HIDDEN);
            }
        }.run(500);
    }

    protected void initializeWorkbench() {
        this.setupRpcDefaultErrorCallback();
        this.loadPreferences();
        this.loadStyles();
    }

    protected void setupRpcDefaultErrorCallback() {
        ErrorCallback originalRpcErrorCallback = AbstractRpcProxy.DEFAULT_RPC_ERROR_CALLBACK;
        AbstractRpcProxy.DEFAULT_RPC_ERROR_CALLBACK = (m, t) -> {
            m.remove("MethodParms");
            m.remove("MethodReply");
            this.genericErrorPopup.setup(BusToolsCli.encodeMessage((Message)m));
            return originalRpcErrorCallback.error(m, t);
        };
    }
}

