/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import javax.inject.Inject;
import org.guvnor.common.services.project.model.Module;
import org.kie.api.runtime.KieContainer;
import org.kie.workbench.common.services.backend.builder.core.Builder;
import org.kie.workbench.common.services.backend.builder.service.BuildInfo;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoImpl;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.vfs.Path;

public abstract class AbstractKieContainerService {
    @Inject
    private KieModuleService moduleService;
    @Inject
    private BuildInfoService buildInfoService;

    protected KieContainer getKieContainer(Path path) {
        KieModule kieModule = (KieModule)this.moduleService.resolveModule(path);
        return this.assertKieContainerIsValid(this.buildInfoService.getBuildInfo((Module)kieModule).getKieContainer());
    }

    protected KieContainer getKieContainerClone(Path path) {
        KieModule kieModule = (KieModule)this.moduleService.resolveModule(path);
        BuildInfo buildInfo = this.buildInfoService.getBuildInfo((Module)kieModule);
        if (buildInfo instanceof BuildInfoImpl) {
            Builder clone = ((BuildInfoImpl)buildInfo).getBuilder().clone();
            clone.build();
            return this.assertKieContainerIsValid(clone.getKieContainer());
        }
        throw new IllegalStateException("Failed to clone Builder.");
    }

    private KieContainer assertKieContainerIsValid(KieContainer kieContainer) {
        if (kieContainer == null) {
            throw new IllegalArgumentException("Retrieving KieContainer has failed. Fix all compilation errors within the project and build the project again.");
        }
        return kieContainer;
    }
}

