/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.storage;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;

public class InMemoryKieServerTemplateStorage
implements KieServerTemplateStorage {
    private static InMemoryKieServerTemplateStorage INSTANCE = new InMemoryKieServerTemplateStorage();
    private Map<String, ServerTemplate> store = new HashMap<String, ServerTemplate>();
    private Map<String, ServerTemplateKey> storeKeys = new ConcurrentHashMap<String, ServerTemplateKey>();

    protected InMemoryKieServerTemplateStorage() {
    }

    public static InMemoryKieServerTemplateStorage getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate store(ServerTemplate serverTemplate) {
        Map<String, ServerTemplate> map = this.store;
        synchronized (map) {
            this.storeKeys.put(serverTemplate.getId(), new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
            return this.store.put(serverTemplate.getId(), serverTemplate);
        }
    }

    public List<ServerTemplateKey> loadKeys() {
        return new ArrayList<ServerTemplateKey>(this.storeKeys.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerTemplate> load() {
        Map<String, ServerTemplate> map = this.store;
        synchronized (map) {
            return this.store.values().stream().map(this::cloneServerTemplate).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate load(String identifier) {
        Map<String, ServerTemplate> map = this.store;
        synchronized (map) {
            return this.cloneServerTemplate(this.store.get(identifier));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String identifier) {
        Map<String, ServerTemplate> map = this.store;
        synchronized (map) {
            return this.store.containsKey(identifier);
        }
    }

    private ServerTemplate cloneServerTemplate(ServerTemplate current) {
        if (current == null) {
            return null;
        }
        List specs = current.getContainersSpec().stream().map(ContainerSpec::new).collect(Collectors.toList());
        ServerTemplate serverTemplate = new ServerTemplate(current.getId(), current.getName(), new ArrayList(current.getCapabilities()), current.getConfigs().isEmpty() ? new EnumMap(Capability.class) : new EnumMap(current.getConfigs()), specs, new ArrayList(current.getServerInstanceKeys()));
        serverTemplate.setMode(current.getMode());
        return serverTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate update(ServerTemplate serverTemplate) {
        Map<String, ServerTemplate> map = this.store;
        synchronized (map) {
            this.delete(serverTemplate.getId());
            this.store(serverTemplate);
        }
        return serverTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate delete(String identifier) {
        Map<String, ServerTemplate> map = this.store;
        synchronized (map) {
            this.storeKeys.remove(identifier);
            return this.store.remove(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, ServerTemplate> map = this.store;
        synchronized (map) {
            this.store.clear();
            this.storeKeys.clear();
        }
    }
}

