/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.util.Optional;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.AssociationDirection;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.BasePropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.util.PropertyWriterUtils;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.NonDirectionalAssociation;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

public class AssociationPropertyWriter
extends BasePropertyWriter {
    private Association association;
    private BasePropertyWriter source;
    private BasePropertyWriter target;
    private BPMNEdge bpmnEdge;

    public AssociationPropertyWriter(Association association, VariableScope variableScope) {
        super((BaseElement)association, variableScope);
        this.association = association;
    }

    public void setConnection(ViewConnector<? extends BPMNViewDefinition> connector) {
        if (connector.getSourceConnection().isPresent() && connector.getTargetConnection().isPresent()) {
            Connection sourceConnection = (Connection)connector.getSourceConnection().get();
            Connection targetConnection = (Connection)connector.getTargetConnection().get();
            ControlPoint[] controlPoints = connector.getControlPoints();
            this.bpmnEdge = PropertyWriterUtils.createBPMNEdge(this.source, this.target, sourceConnection, controlPoints, targetConnection);
            this.bpmnEdge.setBpmnElement((BaseElement)this.association);
        }
    }

    @Override
    public BPMNEdge getEdge() {
        return this.bpmnEdge;
    }

    @Override
    public void setSource(BasePropertyWriter pSrc) {
        this.source = pSrc;
        this.association.setSourceRef(pSrc.getElement());
        pSrc.setTarget(this);
    }

    @Override
    public void setTarget(BasePropertyWriter pTgt) {
        this.target = pTgt;
        this.association.setTargetRef(pTgt.getElement());
        pTgt.setSource(this);
    }

    public void setDirectionAssociation(org.kie.workbench.common.stunner.bpmn.definition.Association definition) {
        this.association.setAssociationDirection(Optional.ofNullable(definition).filter(NonDirectionalAssociation.class::isInstance).map(def -> AssociationDirection.NONE).orElse(AssociationDirection.ONE));
    }
}

