/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.workitem.service;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.WorkItemDefinitionParser;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.WorkItemDefinitionResources;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.service.WorkItemDefinitionService;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.DirectoryStream;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;

@ApplicationScoped
@Service
public class WorkItemDefinitionVFSLookupService
implements WorkItemDefinitionService<Metadata> {
    private static final Logger LOG = LoggerFactory.getLogger((String)WorkItemDefinitionVFSLookupService.class.getName());
    private final VFSService vfsService;
    private final WorkItemDefinitionResources resources;

    protected WorkItemDefinitionVFSLookupService() {
        this.vfsService = null;
        this.resources = null;
    }

    @Inject
    public WorkItemDefinitionVFSLookupService(VFSService vfsService, WorkItemDefinitionResources resources) {
        this.vfsService = vfsService;
        this.resources = resources;
    }

    public Collection<WorkItemDefinition> execute(Metadata metadata) {
        return this.search(metadata);
    }

    public Collection<WorkItemDefinition> search(Metadata metadata) {
        return this.resources.resolveResources(metadata).stream().flatMap(path -> this.search(metadata, (Path)path).stream()).collect(Collectors.toSet());
    }

    public Collection<WorkItemDefinition> search(Metadata metadata, Path root) {
        DirectoryStream files = this.vfsService.newDirectoryStream(root, WorkItemDefinitionVFSLookupService::isWorkItemPathValid);
        return StreamSupport.stream(files.spliterator(), false).flatMap(resource -> this.get(metadata, (Path)resource).stream()).collect(Collectors.toList());
    }

    public Collection<WorkItemDefinition> get(Metadata metadata, Path resource) {
        String content = this.vfsService.readAllString(resource);
        try {
            return WorkItemDefinitionParser.parse(content, wid -> resource.toURI(), icon -> this.resources.generateIconDataURI(metadata, resource, (String)icon));
        }
        catch (Exception e) {
            LOG.error("Error parsing work item definitions for path [" + resource + "]", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static boolean isWorkItemPathValid(Path path) {
        return WorkItemDefinitionResources.isWorkItemDefinition(path) && !WorkItemDefinitionResources.isHidden(path);
    }
}

