/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.ProjectImports;
import org.kie.scanner.KieModuleMetaData;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.kie.soup.project.datamodel.commons.util.RawMVELEvaluator;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.soup.project.datamodel.oracle.TypeSource;
import org.kie.workbench.common.services.backend.builder.core.TypeSourceResolver;
import org.kie.workbench.common.services.backend.builder.service.BuildInfo;
import org.kie.workbench.common.services.datamodel.backend.server.builder.projects.ModuleDataModelOracleBuilder;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.kie.workbench.common.services.shared.whitelist.PackageNameWhiteListService;
import org.kie.workbench.common.services.shared.whitelist.WhiteList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public class ModuleDataModelOracleBuilderProvider {
    private static final Logger log = LoggerFactory.getLogger(ModuleDataModelOracleBuilderProvider.class);
    private ProjectImportsService importsService;
    private PackageNameWhiteListService packageNameWhiteListService;

    public ModuleDataModelOracleBuilderProvider() {
    }

    @Inject
    public ModuleDataModelOracleBuilderProvider(PackageNameWhiteListService packageNameWhiteListService, ProjectImportsService importsService) {
        this.packageNameWhiteListService = packageNameWhiteListService;
        this.importsService = importsService;
    }

    public InnerBuilder newBuilder(KieModule project, BuildInfo buildInfo) {
        KieModuleMetaData kieModuleMetaData = buildInfo.getKieModuleMetaDataIgnoringErrors();
        TypeSourceResolver typeSourceResolver = buildInfo.getTypeSourceResolver(kieModuleMetaData);
        return new InnerBuilder(project, kieModuleMetaData, typeSourceResolver);
    }

    class InnerBuilder {
        private final ModuleDataModelOracleBuilder pdBuilder = ModuleDataModelOracleBuilder.newModuleOracleBuilder((MVELEvaluator)new RawMVELEvaluator());
        private final KieModule project;
        private final KieModuleMetaData kieModuleMetaData;
        private final TypeSourceResolver typeSourceResolver;

        private InnerBuilder(KieModule project, KieModuleMetaData kieModuleMetaData, TypeSourceResolver typeSourceResolver) {
            this.project = project;
            this.kieModuleMetaData = kieModuleMetaData;
            this.typeSourceResolver = typeSourceResolver;
        }

        public ModuleDataModelOracle build() {
            this.addFromKieModuleMetadata();
            this.addExternalImports();
            return this.pdBuilder.build();
        }

        private void addExternalImports() {
            if (Files.exists((Path)Paths.convert((org.uberfire.backend.vfs.Path)this.project.getImportsPath()), (LinkOption[])new LinkOption[0])) {
                for (Import item : this.getImports()) {
                    this.addClass(item);
                }
            }
        }

        private void addFromKieModuleMetadata() {
            for (String packageName : this.getFilteredPackageNames()) {
                this.pdBuilder.addPackage(packageName);
                this.addClasses(packageName, this.kieModuleMetaData.getClasses(packageName));
            }
        }

        private WhiteList getFilteredPackageNames() {
            return ModuleDataModelOracleBuilderProvider.this.packageNameWhiteListService.filterPackageNames((Module)this.project, this.kieModuleMetaData.getPackages());
        }

        private void addClasses(String packageName, Collection<String> classes) {
            for (String className : classes) {
                this.addClass(packageName, className);
            }
        }

        private void addClass(Import item) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(item.getType());
                this.pdBuilder.addClass(clazz, false, this::resolveTypeSource);
            }
            catch (ClassNotFoundException cnfe) {
                log.debug(cnfe.getMessage());
            }
            catch (IOException ioe) {
                log.debug(ioe.getMessage());
            }
        }

        private void addClass(String packageName, String className) {
            try {
                Class clazz = this.kieModuleMetaData.getClass(packageName, className);
                this.pdBuilder.addClass(clazz, this.kieModuleMetaData.getTypeMetaInfo(clazz).isEvent(), this::resolveTypeSource);
            }
            catch (Throwable e) {
                log.debug(e.getMessage());
            }
        }

        private List<Import> getImports() {
            return ((ProjectImports)ModuleDataModelOracleBuilderProvider.this.importsService.load(this.project.getImportsPath())).getImports().getImports();
        }

        private TypeSource resolveTypeSource(String type) {
            String pkg = "";
            int index = type.lastIndexOf(".");
            if (index != -1) {
                pkg = type.substring(0, index);
                type = type.substring(index + 1);
            }
            Class clazz = this.kieModuleMetaData.getClass(pkg, type);
            return this.typeSourceResolver.getTypeSource(clazz);
        }
    }
}

